/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.criteria.backend.ExpressionNaming;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.backend.UniqueCachedNaming;
import org.immutables.criteria.expression.AggregationOperators;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.ImmutableQuery;
import org.immutables.criteria.expression.Operator;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.mongo.FindVisitor;

class AggregationQuery {
    private final Query query;
    private final PathNaming pathNaming;
    private final ExpressionNaming projectionNaming;
    private final BiMap<Expression, String> naming;
    private final CodecRegistry codecRegistry;

    AggregationQuery(Query query, PathNaming pathNaming) {
        this.query = AggregationQuery.maybeRewriteDistinctToGroupBy(query);
        this.pathNaming = Objects.requireNonNull(pathNaming, "naming");
        HashBiMap biMap = HashBiMap.create();
        List<Path> paths = Stream.concat(query.projections().stream(), Stream.concat(query.groupBy().stream(), query.collations().stream().map(Collation::expression))).map(AggregationQuery::extractPath).collect(Collectors.toList());
        ExpressionNaming naming = ExpressionNaming.from((Function)UniqueCachedNaming.of(paths.iterator()));
        paths.forEach(arg_0 -> AggregationQuery.lambda$new$0((BiMap)biMap, naming, arg_0));
        this.projectionNaming = ExpressionNaming.from((Function)UniqueCachedNaming.of((Iterable)query.projections()));
        this.naming = ImmutableBiMap.copyOf((Map)biMap);
        this.codecRegistry = MongoClientSettings.getDefaultCodecRegistry();
    }

    private static Query maybeRewriteDistinctToGroupBy(Query query) {
        Objects.requireNonNull(query, "query");
        if (!query.distinct()) {
            return query;
        }
        if (query.distinct() && !query.groupBy().isEmpty()) {
            throw new UnsupportedOperationException(String.format("Both DISTINCT and groupBy (%s) are present. Use either.", query.groupBy()));
        }
        return ImmutableQuery.builder().from(query).groupBy((Iterable)query.projections()).build();
    }

    private static Path extractPath(Expression expression) {
        if (expression instanceof Path) {
            return (Path)expression;
        }
        if (expression instanceof Call) {
            Call call = (Call)expression;
            if (call.operator().arity() != Operator.Arity.UNARY) {
                throw new IllegalArgumentException("Expected unary operator but got " + call);
            }
            Expression arg = (Expression)call.arguments().get(0);
            Preconditions.checkArgument((boolean)(arg instanceof Path), (String)"expected path got %s", (Object)arg);
            return (Path)arg;
        }
        throw new IllegalArgumentException("Can't extract path from " + expression);
    }

    List<Bson> toPipeline() {
        ArrayList aggregates = new ArrayList();
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(Arrays.asList(new MatchPipeline(), new NameAndExtractFields(), new Group(), new Sort(), new Skip(), new Limit(), new CountAll()));
        pipelines.forEach(p -> p.process(aggregates::add));
        return Collections.unmodifiableList(aggregates);
    }

    private BsonField accumulator(String field, Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof Call), (String)"not a call %s", (Object)expression);
        Call call = (Call)expression;
        Operator op = call.operator();
        Preconditions.checkArgument((boolean)AggregationOperators.isAggregation((Operator)op), (String)"not an aggregation operator: %s", (Object)op);
        String name = "$" + (String)this.naming.get((Object)AggregationQuery.extractPath(expression));
        if (op == AggregationOperators.AVG) {
            return Accumulators.avg((String)field, (Object)name);
        }
        if (op == AggregationOperators.COUNT) {
            return Accumulators.sum((String)field, (Object)1);
        }
        if (op == AggregationOperators.MAX) {
            return Accumulators.max((String)field, (Object)name);
        }
        if (op == AggregationOperators.MIN) {
            return Accumulators.min((String)field, (Object)name);
        }
        if (op == AggregationOperators.SUM) {
            return Accumulators.sum((String)field, (Object)name);
        }
        throw new IllegalArgumentException(String.format("Unknown aggregation operator %s from %s", op, expression));
    }

    private static /* synthetic */ void lambda$new$0(BiMap biMap, ExpressionNaming naming, Path p) {
        biMap.put((Object)p, (Object)naming.name((Expression)p));
    }

    private static interface Pipeline {
        public void process(Consumer<Bson> var1);
    }

    private class MatchPipeline
    implements Pipeline {
        private MatchPipeline() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            AggregationQuery.this.query.filter().ifPresent(expr -> {
                Bson filter = (Bson)expr.accept((ExpressionVisitor)new FindVisitor(AggregationQuery.this.pathNaming, AggregationQuery.this.codecRegistry));
                Objects.requireNonNull(filter, "null filter");
                consumer.accept(Aggregates.match((Bson)filter));
            });
        }
    }

    private class NameAndExtractFields
    implements Pipeline {
        private NameAndExtractFields() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            BsonDocument projections = new BsonDocument();
            AggregationQuery.this.naming.forEach((expr, name) -> projections.put(name, (BsonValue)new BsonString("$" + AggregationQuery.this.pathNaming.name(AggregationQuery.extractPath(expr)))));
            if (!projections.isEmpty()) {
                consumer.accept(Aggregates.project((Bson)projections));
            }
        }
    }

    private class Group
    implements Pipeline {
        private Group() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            BsonDocument groupId;
            BsonDocument id = new BsonDocument();
            ArrayList<BsonField> accumulators = new ArrayList<BsonField>();
            BsonDocument project = new BsonDocument();
            AggregationQuery.this.query.groupBy().forEach(groupBy -> {
                String alias = (String)AggregationQuery.this.naming.get((Object)AggregationQuery.extractPath(groupBy));
                id.put(alias, (BsonValue)new BsonString("$" + alias));
            });
            for (Expression expr : AggregationQuery.this.query.projections()) {
                String alias = (String)AggregationQuery.this.naming.get((Object)AggregationQuery.extractPath(expr));
                String uniq = AggregationQuery.this.projectionNaming.name(expr);
                if (AggregationQuery.this.query.groupBy().contains(expr)) {
                    project.put(alias, (BsonValue)new BsonString(id.size() == 1 ? "$_id" : "$_id." + alias));
                    continue;
                }
                if (expr instanceof Call) {
                    accumulators.add(AggregationQuery.this.accumulator(uniq, expr));
                    project.put(uniq, (BsonValue)new BsonString("$" + uniq));
                    continue;
                }
                project.put(uniq, (BsonValue)new BsonString("$" + uniq));
            }
            if (AggregationQuery.this.query.distinct() && !id.isEmpty()) {
                groupId = id.size() == 1 ? (BsonValue)id.values().iterator().next() : id;
                consumer.accept(Aggregates.group((Object)groupId, (BsonField[])new BsonField[0]));
            }
            if (!accumulators.isEmpty()) {
                groupId = id.size() == 1 ? (BsonValue)id.values().iterator().next() : id;
                consumer.accept(Aggregates.group((Object)groupId, accumulators));
            }
            if (!project.isEmpty()) {
                consumer.accept(Aggregates.project((Bson)project));
            }
        }
    }

    private class Sort
    implements Pipeline {
        private Sort() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            Function<Collation, Bson> toSortFn = col -> {
                String name = (String)AggregationQuery.this.naming.get((Object)col.path());
                return col.direction().isAscending() ? Sorts.ascending((String[])new String[]{name}) : Sorts.descending((String[])new String[]{name});
            };
            BsonDocument sort = new BsonDocument();
            for (Collation collation : AggregationQuery.this.query.collations()) {
                sort.putAll((Map)toSortFn.apply(collation).toBsonDocument(BsonDocument.class, AggregationQuery.this.codecRegistry));
            }
            if (!sort.isEmpty()) {
                consumer.accept(Aggregates.sort((Bson)sort));
            }
        }
    }

    private class Skip
    implements Pipeline {
        private Skip() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            AggregationQuery.this.query.offset().ifPresent(offset -> consumer.accept(Aggregates.skip((int)((int)offset))));
        }
    }

    private class Limit
    implements Pipeline {
        private Limit() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            AggregationQuery.this.query.limit().ifPresent(limit -> consumer.accept(Aggregates.limit((int)((int)limit))));
        }
    }

    private class CountAll
    implements Pipeline {
        private CountAll() {
        }

        @Override
        public void process(Consumer<Bson> consumer) {
            if (!AggregationQuery.this.query.count()) {
                return;
            }
            BsonDocument bson = new BsonDocument();
            bson.put("$count", (BsonValue)new BsonString("count"));
            consumer.accept((Bson)bson);
        }
    }
}

