/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import java.util.Objects;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.criteria.backend.ContainerNaming;

public interface CollectionResolver {
    public MongoCollection<?> resolve(Class<?> var1);

    public static CollectionResolver defaultResolver(MongoDatabase database, CodecRegistry registry) {
        Objects.requireNonNull(database, "database");
        Objects.requireNonNull(registry, "registry");
        return entityClass -> {
            String collectionName = ContainerNaming.DEFAULT.name(entityClass);
            return database.getCollection(collectionName).withDocumentClass(entityClass).withCodecRegistry(registry);
        };
    }
}

