/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mongodb.client.model.Filters;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.AbstractExpressionVisitor;
import org.immutables.criteria.expression.Call;
import org.immutables.criteria.expression.ComparableOperators;
import org.immutables.criteria.expression.Constant;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.expression.Expressions;
import org.immutables.criteria.expression.IterableOperators;
import org.immutables.criteria.expression.Operator;
import org.immutables.criteria.expression.Operators;
import org.immutables.criteria.expression.OptionalOperators;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.StringOperators;
import org.immutables.criteria.expression.Visitors;

class FindVisitor
extends AbstractExpressionVisitor<Bson> {
    private final PathNaming naming;
    private final CodecRegistry codecRegistry;

    FindVisitor(PathNaming pathNaming, CodecRegistry codecRegistry) {
        super(e -> {
            throw new UnsupportedOperationException();
        });
        this.naming = Objects.requireNonNull(pathNaming, "pathNaming");
        this.codecRegistry = Objects.requireNonNull(codecRegistry, "codecRegistry");
    }

    public Bson visit(Call call) {
        Operator op = call.operator();
        List args = call.arguments();
        if (op == OptionalOperators.IS_ABSENT || op == OptionalOperators.IS_PRESENT) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object)op, (int)args.size());
            String field = this.naming.name(Visitors.toPath((Expression)((Expression)args.get(0))));
            Bson filter = op == OptionalOperators.IS_PRESENT ? Filters.and((Bson[])new Bson[]{Filters.exists((String)field), Filters.ne((String)field, null)}) : Filters.or((Bson[])new Bson[]{Filters.exists((String)field, (boolean)false), Filters.eq((String)field, null)});
            return filter;
        }
        if (op == Operators.AND || op == Operators.OR) {
            List list = call.arguments().stream().map(a -> (Bson)a.accept((ExpressionVisitor)this)).collect(Collectors.toList());
            return op == Operators.AND ? Filters.and(list) : Filters.or(list);
        }
        if (op == Operators.NOT) {
            return this.negate((Expression)args.get(0));
        }
        if (op == IterableOperators.IS_EMPTY || op == IterableOperators.NOT_EMPTY) {
            Preconditions.checkArgument((args.size() == 1 ? 1 : 0) != 0, (String)"Size should be 1 for %s but was %s", (Object)op, (int)args.size());
            String field = this.naming.name(Visitors.toPath((Expression)((Expression)args.get(0))));
            return op == IterableOperators.IS_EMPTY ? Filters.eq((String)field, Collections.emptyList()) : Filters.and((Bson[])new Bson[]{Filters.exists((String)field), Filters.ne((String)field, null), Filters.ne((String)field, Collections.emptyList())});
        }
        if (op.arity() == Operator.Arity.BINARY) {
            return this.binaryCall(call);
        }
        throw new UnsupportedOperationException(String.format("Not yet supported (%s): %s", call.operator(), call));
    }

    private Bson binaryCall(Call call) {
        Preconditions.checkArgument((call.operator().arity() == Operator.Arity.BINARY ? 1 : 0) != 0, (String)"%s is not binary", (Object)call.operator());
        Operator op = call.operator();
        Expression left = (Expression)call.arguments().get(0);
        Expression right = (Expression)call.arguments().get(1);
        if (!(left instanceof Path) || !(right instanceof Constant)) {
            return ((BsonValue)call.accept((ExpressionVisitor)new MongoExpr(this.naming, this.codecRegistry))).asDocument();
        }
        String field = this.naming.name(Visitors.toPath((Expression)left));
        Object value = Visitors.toConstant((Expression)right).value();
        if (op == Operators.EQUAL || op == Operators.NOT_EQUAL) {
            if ("".equals(value) && op == Operators.NOT_EQUAL) {
                return Filters.and((Bson[])new Bson[]{Filters.nin((String)field, (Object[])new Object[]{value, null}), Filters.exists((String)field)});
            }
            return op == Operators.EQUAL ? Filters.eq((String)field, (Object)value) : Filters.ne((String)field, (Object)value);
        }
        if (ComparableOperators.isComparable((Operator)op)) {
            if (op == ComparableOperators.GREATER_THAN) {
                return Filters.gt((String)field, (Object)value);
            }
            if (op == ComparableOperators.GREATER_THAN_OR_EQUAL) {
                return Filters.gte((String)field, (Object)value);
            }
            if (op == ComparableOperators.LESS_THAN) {
                return Filters.lt((String)field, (Object)value);
            }
            if (op == ComparableOperators.LESS_THAN_OR_EQUAL) {
                return Filters.lte((String)field, (Object)value);
            }
            throw new UnsupportedOperationException("Unknown comparison " + call);
        }
        if (op == Operators.IN || op == Operators.NOT_IN) {
            ImmutableSet values = ImmutableSet.copyOf((Collection)Visitors.toConstant((Expression)right).values());
            Preconditions.checkNotNull((Object)values, (String)"not expected to be null for %s", (Object)op);
            if (values.size() == 1) {
                Operators newOperator = op == Operators.IN ? Operators.EQUAL : Operators.NOT_EQUAL;
                Call newCall = Expressions.binaryCall((Operator)newOperator, (Expression)left, (Expression)Expressions.constant(values.iterator().next()));
                return this.binaryCall(newCall);
            }
            return op == Operators.IN ? Filters.in((String)field, (Iterable)values) : Filters.nin((String)field, (Iterable)values);
        }
        if (op == StringOperators.MATCHES || op == StringOperators.CONTAINS) {
            Object newValue = value;
            if (op == StringOperators.CONTAINS) {
                newValue = Pattern.compile(".*" + Pattern.quote(value.toString()) + ".*");
            }
            Preconditions.checkArgument((boolean)(newValue instanceof Pattern), (String)"%s is not regex pattern", (Object)value);
            return Filters.regex((String)field, (Pattern)((Pattern)newValue));
        }
        if (op == IterableOperators.HAS_SIZE) {
            Preconditions.checkArgument((boolean)(value instanceof Number), (String)"%s is not a number", (Object)value);
            int size = ((Number)value).intValue();
            return Filters.size((String)field, (int)size);
        }
        if (op == IterableOperators.CONTAINS) {
            return Filters.eq((String)field, (Object)value);
        }
        if (op == StringOperators.HAS_LENGTH) {
            Preconditions.checkArgument((boolean)(value instanceof Number), (String)"%s is not a number", (Object)value);
            int length = ((Number)value).intValue();
            Document lengthExpr = Document.parse((String)String.format("{$expr:{$eq:[{$strLenCP: \"$%s\"}, %d]}}}", field, length));
            return Filters.and((Bson[])new Bson[]{Filters.exists((String)field), Filters.ne((String)field, null), lengthExpr});
        }
        if (op == StringOperators.STARTS_WITH || op == StringOperators.ENDS_WITH) {
            String pattern = String.format("%s%s%s", op == StringOperators.STARTS_WITH ? "^" : "", Pattern.quote(value.toString()), op == StringOperators.ENDS_WITH ? "$" : "");
            return Filters.regex((String)field, (Pattern)Pattern.compile(pattern));
        }
        throw new UnsupportedOperationException(String.format("Unsupported binary call %s", call));
    }

    private Bson negate(Expression expression) {
        if (!(expression instanceof Call)) {
            return Filters.not((Bson)((Bson)expression.accept((ExpressionVisitor)this)));
        }
        Call notCall = (Call)expression;
        Operator notOperator = notCall.operator();
        if (notOperator == Operators.NOT) {
            return (Bson)((Expression)notCall.arguments().get(0)).accept((ExpressionVisitor)this);
        }
        if (notOperator == Operators.EQUAL) {
            return this.newCall(notCall, (Operator)Operators.NOT_EQUAL);
        }
        if (notOperator == Operators.NOT_EQUAL) {
            return this.newCall(notCall, (Operator)Operators.EQUAL);
        }
        if (notOperator == Operators.IN) {
            return this.newCall(notCall, (Operator)Operators.NOT_IN);
        }
        if (notOperator == Operators.NOT_IN) {
            return this.newCall(notCall, (Operator)Operators.IN);
        }
        if (notOperator == Operators.OR) {
            return Filters.nor((Iterable)notCall.arguments().stream().map(a -> (Bson)a.accept((ExpressionVisitor)this)).collect(Collectors.toList()));
        }
        if (notOperator == Operators.AND) {
            return Filters.or((Iterable)notCall.arguments().stream().map(this::negate).collect(Collectors.toList()));
        }
        if (notOperator == OptionalOperators.IS_ABSENT || notOperator == OptionalOperators.IS_PRESENT) {
            OptionalOperators newOp = notOperator == OptionalOperators.IS_ABSENT ? OptionalOperators.IS_PRESENT : OptionalOperators.IS_ABSENT;
            return this.newCall(notCall, (Operator)newOp);
        }
        if (notOperator == IterableOperators.IS_EMPTY || notOperator == IterableOperators.NOT_EMPTY) {
            IterableOperators newOp = notOperator == IterableOperators.IS_EMPTY ? IterableOperators.NOT_EMPTY : IterableOperators.IS_EMPTY;
            return this.newCall(notCall, (Operator)newOp);
        }
        return Filters.not((Bson)((Bson)notCall.accept((ExpressionVisitor)this)));
    }

    private Bson newCall(Call existing, Operator newOperator) {
        return this.visit(Expressions.call((Operator)newOperator, (Iterable)existing.arguments()));
    }

    private static class MongoExpr
    extends AbstractExpressionVisitor<BsonValue> {
        private final PathNaming pathNaming;
        private final CodecRegistry codecRegistry;

        private MongoExpr(PathNaming pathNaming, CodecRegistry codecRegistry) {
            super(e -> {
                throw new UnsupportedOperationException();
            });
            this.pathNaming = pathNaming;
            this.codecRegistry = codecRegistry;
        }

        public BsonValue visit(Call call) {
            Operator op = call.operator();
            if (op.arity() == Operator.Arity.BINARY) {
                return this.visitBinary(call, (Expression)call.arguments().get(0), (Expression)call.arguments().get(1));
            }
            if (op.arity() == Operator.Arity.UNARY) {
                return this.visitUnary(call, (Expression)call.arguments().get(0));
            }
            throw new UnsupportedOperationException("Don't know how to handle " + call);
        }

        private BsonValue visitBinary(Call call, Expression left, Expression right) {
            String mongoOp;
            Operator op = call.operator();
            if (op == Operators.EQUAL) {
                mongoOp = "$eq";
            } else if (op == Operators.NOT_EQUAL) {
                mongoOp = "$ne";
            } else if (op == Operators.IN) {
                mongoOp = "$in";
            } else if (op == Operators.NOT_IN) {
                mongoOp = "$in";
            } else {
                throw new UnsupportedOperationException(String.format("Unknown operator %s for call %s", op, call));
            }
            BsonArray args = new BsonArray();
            args.add((BsonValue)left.accept((ExpressionVisitor)this));
            args.add((BsonValue)right.accept((ExpressionVisitor)this));
            BsonDocument expr = new BsonDocument(mongoOp, (BsonValue)args);
            if (op == Operators.NOT_IN) {
                expr = new BsonDocument("$not", (BsonValue)expr);
            }
            return Filters.expr((Object)expr).toBsonDocument(BsonDocument.class, this.codecRegistry);
        }

        private BsonValue visitUnary(Call call, Expression arg) {
            Operator op = call.operator();
            if (op == StringOperators.TO_LOWER_CASE || op == StringOperators.TO_UPPER_CASE) {
                String key = op == StringOperators.TO_LOWER_CASE ? "$toLower" : "$toUpper";
                BsonValue value = (BsonValue)arg.accept((ExpressionVisitor)this);
                return new BsonDocument(key, value);
            }
            throw new UnsupportedOperationException("Unknown unary call " + call);
        }

        public BsonValue visit(Path path) {
            return new BsonString('$' + this.pathNaming.name(path));
        }

        public BsonValue visit(Constant constant) {
            Object value = constant.value();
            if (value == null) {
                return BsonNull.VALUE;
            }
            if (value instanceof Iterable) {
                return Filters.in((String)"ignore", (Iterable)((Iterable)value)).toBsonDocument(BsonDocument.class, this.codecRegistry).get((Object)"ignore").asDocument().get((Object)"$in").asArray();
            }
            return Filters.eq((String)"ignore", (Object)value).toBsonDocument(BsonDocument.class, this.codecRegistry).get((Object)"ignore");
        }
    }
}

