/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.mongo.CollectionResolver;
import org.immutables.criteria.mongo.MongoSetup;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoSetup", generator="Immutables")
@Immutable
final class ImmutableMongoSetup
implements MongoSetup {
    private final CollectionResolver collectionResolver;
    private final KeyExtractor.Factory keyExtractorFactory;
    private final PathNaming pathNaming;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoSetup(CollectionResolver collectionResolver) {
        this.collectionResolver = Objects.requireNonNull(collectionResolver, "collectionResolver");
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.pathNaming = this.initShim.pathNaming();
        this.initShim = null;
    }

    private ImmutableMongoSetup(Builder builder) {
        this.collectionResolver = builder.collectionResolver;
        if (builder.keyExtractorFactory != null) {
            this.initShim.keyExtractorFactory(builder.keyExtractorFactory);
        }
        if (builder.pathNaming != null) {
            this.initShim.pathNaming(builder.pathNaming);
        }
        this.keyExtractorFactory = this.initShim.keyExtractorFactory();
        this.pathNaming = this.initShim.pathNaming();
        this.initShim = null;
    }

    private ImmutableMongoSetup(CollectionResolver collectionResolver, KeyExtractor.Factory keyExtractorFactory, PathNaming pathNaming) {
        this.collectionResolver = collectionResolver;
        this.keyExtractorFactory = keyExtractorFactory;
        this.pathNaming = pathNaming;
        this.initShim = null;
    }

    private KeyExtractor.Factory keyExtractorFactoryInitialize() {
        return MongoSetup.super.keyExtractorFactory();
    }

    private PathNaming pathNamingInitialize() {
        return MongoSetup.super.pathNaming();
    }

    @Override
    public CollectionResolver collectionResolver() {
        return this.collectionResolver;
    }

    @Override
    public KeyExtractor.Factory keyExtractorFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyExtractorFactory() : this.keyExtractorFactory;
    }

    @Override
    public PathNaming pathNaming() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pathNaming() : this.pathNaming;
    }

    public final ImmutableMongoSetup withCollectionResolver(CollectionResolver value) {
        if (this.collectionResolver == value) {
            return this;
        }
        CollectionResolver newValue = Objects.requireNonNull(value, "collectionResolver");
        return new ImmutableMongoSetup(newValue, this.keyExtractorFactory, this.pathNaming);
    }

    public final ImmutableMongoSetup withKeyExtractorFactory(KeyExtractor.Factory value) {
        if (this.keyExtractorFactory == value) {
            return this;
        }
        KeyExtractor.Factory newValue = Objects.requireNonNull(value, "keyExtractorFactory");
        return new ImmutableMongoSetup(this.collectionResolver, newValue, this.pathNaming);
    }

    public final ImmutableMongoSetup withPathNaming(PathNaming value) {
        if (this.pathNaming == value) {
            return this;
        }
        PathNaming newValue = Objects.requireNonNull(value, "pathNaming");
        return new ImmutableMongoSetup(this.collectionResolver, this.keyExtractorFactory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoSetup && this.equalTo(0, (ImmutableMongoSetup)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoSetup another) {
        return this.collectionResolver.equals(another.collectionResolver) && this.keyExtractorFactory.equals(another.keyExtractorFactory) && this.pathNaming.equals(another.pathNaming);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.collectionResolver.hashCode();
        h += (h << 5) + this.keyExtractorFactory.hashCode();
        h += (h << 5) + this.pathNaming.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoSetup").omitNullValues().add("collectionResolver", (Object)this.collectionResolver).add("keyExtractorFactory", (Object)this.keyExtractorFactory).add("pathNaming", (Object)this.pathNaming).toString();
    }

    public static ImmutableMongoSetup of(CollectionResolver collectionResolver) {
        return new ImmutableMongoSetup(collectionResolver);
    }

    public static ImmutableMongoSetup copyOf(MongoSetup instance) {
        if (instance instanceof ImmutableMongoSetup) {
            return (ImmutableMongoSetup)instance;
        }
        return new MongoSetup.Builder().from(instance).build();
    }

    @Generated(from="MongoSetup", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_COLLECTION_RESOLVER = 1L;
        private long initBits = 1L;
        @Nullable
        private CollectionResolver collectionResolver;
        @Nullable
        private KeyExtractor.Factory keyExtractorFactory;
        @Nullable
        private PathNaming pathNaming;

        public Builder() {
            if (!(this instanceof MongoSetup.Builder)) {
                throw new UnsupportedOperationException("Use: new MongoSetup.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final MongoSetup.Builder from(MongoSetup instance) {
            Objects.requireNonNull(instance, "instance");
            this.collectionResolver(instance.collectionResolver());
            this.keyExtractorFactory(instance.keyExtractorFactory());
            this.pathNaming(instance.pathNaming());
            return (MongoSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MongoSetup.Builder collectionResolver(CollectionResolver collectionResolver) {
            this.collectionResolver = Objects.requireNonNull(collectionResolver, "collectionResolver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MongoSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MongoSetup.Builder keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = Objects.requireNonNull(keyExtractorFactory, "keyExtractorFactory");
            return (MongoSetup.Builder)this;
        }

        @CanIgnoreReturnValue
        public final MongoSetup.Builder pathNaming(PathNaming pathNaming) {
            this.pathNaming = Objects.requireNonNull(pathNaming, "pathNaming");
            return (MongoSetup.Builder)this;
        }

        public ImmutableMongoSetup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoSetup(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("collectionResolver");
            }
            return "Cannot build MongoSetup, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MongoSetup", generator="Immutables")
    private final class InitShim {
        private byte keyExtractorFactoryBuildStage = 0;
        private KeyExtractor.Factory keyExtractorFactory;
        private byte pathNamingBuildStage = 0;
        private PathNaming pathNaming;

        private InitShim() {
        }

        KeyExtractor.Factory keyExtractorFactory() {
            if (this.keyExtractorFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyExtractorFactoryBuildStage == 0) {
                this.keyExtractorFactoryBuildStage = (byte)-1;
                this.keyExtractorFactory = Objects.requireNonNull(ImmutableMongoSetup.this.keyExtractorFactoryInitialize(), "keyExtractorFactory");
                this.keyExtractorFactoryBuildStage = 1;
            }
            return this.keyExtractorFactory;
        }

        void keyExtractorFactory(KeyExtractor.Factory keyExtractorFactory) {
            this.keyExtractorFactory = keyExtractorFactory;
            this.keyExtractorFactoryBuildStage = 1;
        }

        PathNaming pathNaming() {
            if (this.pathNamingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathNamingBuildStage == 0) {
                this.pathNamingBuildStage = (byte)-1;
                this.pathNaming = Objects.requireNonNull(ImmutableMongoSetup.this.pathNamingInitialize(), "pathNaming");
                this.pathNamingBuildStage = 1;
            }
            return this.pathNaming;
        }

        void pathNaming(PathNaming pathNaming) {
            this.pathNaming = pathNaming;
            this.pathNamingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.keyExtractorFactoryBuildStage == -1) {
                attributes.add("keyExtractorFactory");
            }
            if (this.pathNamingBuildStage == -1) {
                attributes.add("pathNaming");
            }
            return "Cannot build MongoSetup, attribute initializers form cycle " + attributes;
        }
    }
}

