/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import java.util.Objects;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.mongo.CollectionResolver;
import org.immutables.criteria.mongo.MongoSession;
import org.immutables.criteria.mongo.MongoSetup;

public class MongoBackend
implements Backend {
    private final CollectionResolver collectionResolver;
    private final KeyExtractor.Factory keyExtractorFactory;
    private final PathNaming pathNaming;

    public MongoBackend(MongoSetup setup) {
        Objects.requireNonNull(setup, "setup");
        this.collectionResolver = setup.collectionResolver();
        this.keyExtractorFactory = setup.keyExtractorFactory();
        this.pathNaming = setup.pathNaming();
    }

    public Backend.Session open(Class<?> entityType) {
        Objects.requireNonNull(entityType, "context");
        KeyExtractor keyExtractor = this.keyExtractorFactory.create(entityType);
        return new MongoSession(this.collectionResolver.resolve(entityType), keyExtractor, this.pathNaming);
    }
}

