/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.google.common.collect.Iterables;
import com.mongodb.MongoException;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.BackendException;
import org.immutables.criteria.backend.DefaultResult;
import org.immutables.criteria.backend.ExpressionNaming;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.backend.StandardOperations;
import org.immutables.criteria.backend.UniqueCachedNaming;
import org.immutables.criteria.backend.WatchEvent;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ExpressionConverter;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.expression.Visitors;
import org.immutables.criteria.mongo.AggregationQuery;
import org.immutables.criteria.mongo.MongoBackend;
import org.immutables.criteria.mongo.MongoPathNaming;
import org.immutables.criteria.mongo.MongoWatchEvent;
import org.immutables.criteria.mongo.Mongos;
import org.immutables.criteria.mongo.TupleCodecProvider;
import org.reactivestreams.Publisher;

class MongoSession
implements Backend.Session {
    private static final Logger logger = Logger.getLogger(MongoSession.class.getName());
    private final ExpressionConverter<Bson> converter;
    private final MongoCollection<?> collection;
    private final PathNaming pathNaming;
    private final KeyExtractor keyExtractor;

    MongoSession(MongoCollection<?> collection, KeyExtractor keyExtractor, PathNaming pathNaming) {
        this.collection = Objects.requireNonNull(collection, "collection");
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        KeyExtractor.KeyMetadata metadata = keyExtractor.metadata();
        if (metadata.isKeyDefined() && metadata.isExpression() && metadata.keys().size() == 1) {
            Path idProperty = Visitors.toPath((Expression)((Expression)Iterables.getOnlyElement((Iterable)metadata.keys())));
            pathNaming = new MongoPathNaming(idProperty, pathNaming);
        }
        this.pathNaming = pathNaming;
        this.converter = Mongos.converter(this.pathNaming, collection.getCodecRegistry());
    }

    private Bson toBsonFilter(Query query) {
        Bson bson = query.filter().map(arg_0 -> this.converter.convert(arg_0)).orElseGet(BsonDocument::new);
        if (logger.isLoggable(Level.FINE)) {
            BsonDocument filter = bson.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry());
            logger.log(Level.FINE, "Using filter [{0}] to query {1}", new Object[]{filter, this.collection.getNamespace()});
        }
        return bson;
    }

    public Class<?> entityType() {
        return this.collection.getDocumentClass();
    }

    public Backend.Result execute(Backend.Operation operation) {
        return DefaultResult.of(this.executeInternal(operation));
    }

    private Publisher<?> executeInternal(Backend.Operation operation) {
        Object publisher;
        if (operation instanceof StandardOperations.Select) {
            publisher = this.query((StandardOperations.Select)operation);
        } else if (operation instanceof StandardOperations.Insert) {
            publisher = this.insert((StandardOperations.Insert)operation);
        } else if (operation instanceof StandardOperations.Delete) {
            publisher = this.delete((StandardOperations.Delete)operation);
        } else if (operation instanceof StandardOperations.Watch) {
            publisher = this.watch((StandardOperations.Watch)operation);
        } else if (operation instanceof StandardOperations.UpdateByQuery) {
            publisher = this.updateByQuery((StandardOperations.UpdateByQuery)operation);
        } else if (operation instanceof StandardOperations.Update) {
            publisher = this.update((StandardOperations.Update)operation);
        } else if (operation instanceof StandardOperations.GetByKey) {
            publisher = this.getByKey((StandardOperations.GetByKey)operation);
        } else if (operation instanceof StandardOperations.DeleteByKey) {
            publisher = this.deleteByKey((StandardOperations.DeleteByKey)operation);
        } else {
            return Flowable.error((Throwable)new UnsupportedOperationException(String.format("Operation %s not supported", operation)));
        }
        return Flowable.fromPublisher(publisher).compose(MongoSession.wrapMongoException());
    }

    private Publisher<?> query(StandardOperations.Select select) {
        Query query = select.query();
        boolean hasProjections = query.hasProjections();
        boolean useAggregationPipeline = query.hasAggregations() || query.distinct() || query.count() && query.limit().isPresent();
        ExpressionNaming expressionNaming = useAggregationPipeline ? ExpressionNaming.from((Function)UniqueCachedNaming.of((Iterable)query.projections())) : expression -> this.pathNaming.name((Path)expression);
        MongoCollection collection = this.collection;
        if (hasProjections) {
            CodecRegistry newRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{this.collection.getCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new TupleCodecProvider(query, expressionNaming)})});
            collection = this.collection.withDocumentClass(ProjectedTuple.class).withCodecRegistry(newRegistry);
        }
        if (useAggregationPipeline) {
            AggregationQuery agg = new AggregationQuery(query, this.pathNaming);
            if (query.count()) {
                return Flowable.fromPublisher((Publisher)collection.aggregate(agg.toPipeline(), BsonDocument.class)).map(d -> d.get((Object)"count").asNumber().longValue()).defaultIfEmpty((Object)0L);
            }
            return collection.aggregate(agg.toPipeline(), ProjectedTuple.class);
        }
        Bson filter = this.toBsonFilter(query);
        if (query.count()) {
            return Flowable.fromPublisher((Publisher)collection.countDocuments(filter));
        }
        FindPublisher find = collection.find(filter);
        if (!query.collations().isEmpty()) {
            Function<Collation, Bson> toSortFn = col -> {
                String path = this.pathNaming.name(col.path());
                return col.direction().isAscending() ? Sorts.ascending((String[])new String[]{path}) : Sorts.descending((String[])new String[]{path});
            };
            List sorts = query.collations().stream().map(toSortFn).collect(Collectors.toList());
            find.sort(Sorts.orderBy(sorts));
        }
        query.limit().ifPresent(limit -> find.limit((int)limit));
        query.offset().ifPresent(offset -> find.skip((int)offset));
        if (hasProjections) {
            List fields = query.projections().stream().map(p -> this.pathNaming.name((Path)p)).collect(Collectors.toList());
            find.projection(Projections.include(fields));
            return find;
        }
        return find;
    }

    private static <T> FlowableTransformer<T, T> wrapMongoException() {
        Function<Throwable, Throwable> mapFn = e -> e instanceof MongoException ? new BackendException("failed to update", e) : e;
        return flowable -> flowable.onErrorResumeNext(e -> Flowable.error((Throwable)((Throwable)mapFn.apply((Throwable)e))));
    }

    private BsonValue toBsonValue(Object value) {
        BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
        writer.writeStartDocument();
        writer.writeName("value");
        Codec codec = this.collection.getCodecRegistry().get(value.getClass());
        codec.encode((BsonWriter)writer, value, EncoderContext.builder().build());
        writer.writeEndDocument();
        return writer.getDocument().get((Object)"value");
    }

    private <T> Publisher<WriteResult> update(StandardOperations.Update operation) {
        ReplaceOptions options = new ReplaceOptions();
        if (operation.upsert()) {
            options.upsert(operation.upsert());
        }
        List docs = operation.values().stream().map(value -> new ReplaceOneModel((Bson)new BsonDocument("_id", this.toBsonValue(this.keyExtractor.extract(value))), value, options)).collect(Collectors.toList());
        Publisher publisher = this.collection.bulkWrite(docs);
        return Flowable.fromPublisher((Publisher)publisher).map(x -> WriteResult.empty().withUpdatedCount((long)x.getModifiedCount()).withInsertedCount(operation.upsert() ? (long)x.getUpserts().size() : (long)x.getInsertedCount()).withDeletedCount((long)x.getDeletedCount()));
    }

    private Publisher<WriteResult> updateByQuery(StandardOperations.UpdateByQuery operation) {
        Optional replace = operation.replace();
        if (replace.isPresent()) {
            return Flowable.error((Throwable)new UnsupportedOperationException("Replacing whole objects not yet supported by " + MongoBackend.class.getSimpleName()));
        }
        Bson filter = this.toBsonFilter(operation.query());
        Document set = new Document();
        operation.values().forEach((path, value) -> {
            if (path.returnType() != Optional.class && Optional.empty().equals(value)) {
                value = null;
            }
            set.put(Visitors.toPath((Expression)path).toStringPath(), value);
        });
        return Flowable.fromPublisher((Publisher)this.collection.updateMany(filter, (Bson)new Document("$set", (Object)set))).map(x -> WriteResult.empty().withUpdatedCount(x.getModifiedCount()));
    }

    private Publisher<WriteResult> delete(StandardOperations.Delete delete) {
        Bson filter = this.toBsonFilter(delete.query());
        return Flowable.fromPublisher((Publisher)this.collection.deleteMany(filter)).map(r -> WriteResult.empty().withDeletedCount(r.getDeletedCount()));
    }

    private Publisher<WriteResult> deleteByKey(StandardOperations.DeleteByKey deleteByKey) {
        if (deleteByKey.keys().isEmpty()) {
            return Flowable.just((Object)WriteResult.empty());
        }
        Bson filter = Mongos.filterById(deleteByKey.keys());
        return Flowable.fromPublisher((Publisher)this.collection.deleteMany(filter)).map(r -> WriteResult.empty().withDeletedCount(r.getDeletedCount()));
    }

    private Publisher<WriteResult> insert(StandardOperations.Insert insert) {
        MongoCollection<?> collection = this.collection;
        List values = insert.values();
        return Flowable.fromPublisher((Publisher)collection.insertMany(values)).map(r -> WriteResult.empty().withInsertedCount((long)r.getInsertedIds().size()));
    }

    private Publisher<?> getByKey(StandardOperations.GetByKey getByKey) {
        Bson filter = Mongos.filterById(getByKey.keys());
        return Flowable.fromPublisher((Publisher)this.collection.find(filter));
    }

    private <X> Publisher<WatchEvent<X>> watch(StandardOperations.Watch operation) {
        ChangeStreamPublisher watch;
        MongoCollection<?> collection = this.collection;
        if (operation.query().hasProjections()) {
            return Flowable.error((Throwable)new UnsupportedOperationException("Projections are not yet supported with watch operation"));
        }
        if (!operation.query().filter().isPresent()) {
            watch = collection.watch(collection.getDocumentClass());
        } else {
            PathNaming naming = path -> "fullDocument." + this.pathNaming.name(path);
            AggregationQuery agg = new AggregationQuery(operation.query(), naming);
            watch = collection.watch(agg.toPipeline(), collection.getDocumentClass());
        }
        return Flowable.fromPublisher((Publisher)watch.fullDocument(FullDocument.UPDATE_LOOKUP)).map(MongoWatchEvent::fromChangeStream);
    }
}

