/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.mongodb.reactivestreams.client.MongoDatabase;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.mongo.CollectionResolver;
import org.immutables.criteria.mongo.ImmutableMongoSetup;
import org.immutables.value.Value;

@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
@Value.Immutable
public interface MongoSetup {
    @Value.Parameter
    public CollectionResolver collectionResolver();

    @Value.Default
    default public KeyExtractor.Factory keyExtractorFactory() {
        return KeyExtractor.defaultFactory();
    }

    @Value.Default
    default public PathNaming pathNaming() {
        return PathNaming.defaultNaming();
    }

    public static MongoSetup of(CollectionResolver resolver) {
        return ImmutableMongoSetup.of(resolver);
    }

    public static MongoSetup of(MongoDatabase database) {
        return ImmutableMongoSetup.of(CollectionResolver.defaultResolver(database, database.getCodecRegistry()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableMongoSetup.Builder {
    }
}

