/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.immutables.criteria.backend.WatchEvent;

class MongoWatchEvent<T>
implements WatchEvent<T> {
    private final Object key;
    private final T newValue;
    private final WatchEvent.Operation operation;

    MongoWatchEvent(Object key, T newValue, WatchEvent.Operation operation) {
        this.key = key;
        this.newValue = newValue;
        this.operation = operation;
    }

    public Object key() {
        return this.key;
    }

    public Optional<T> newValue() {
        return Optional.ofNullable(this.newValue);
    }

    public WatchEvent.Operation operation() {
        return this.operation;
    }

    static <T> WatchEvent<T> fromChangeStream(ChangeStreamDocument<T> doc) {
        WatchEvent.Operation op;
        Object key = MongoWatchEvent.toInternalKey(doc.getDocumentKey());
        Object newValue = doc.getFullDocument();
        OperationType type = doc.getOperationType();
        switch (type) {
            case INSERT: {
                op = WatchEvent.Operation.INSERT;
                break;
            }
            case REPLACE: {
                op = WatchEvent.Operation.REPLACE;
                break;
            }
            case DELETE: {
                op = WatchEvent.Operation.DELETE;
                break;
            }
            default: {
                op = WatchEvent.Operation.UPDATE;
            }
        }
        return new MongoWatchEvent<Object>(key, newValue, op);
    }

    private static Object toInternalKey(BsonDocument key) {
        if (key == null) {
            return null;
        }
        BsonValue value = key.get((Object)"_id");
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.asString().getValue();
        }
        if (value.isSymbol()) {
            return value.asSymbol().getSymbol();
        }
        if (value.isObjectId()) {
            return value.asObjectId().getValue();
        }
        return null;
    }
}

