/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.mongodb.client.model.Filters;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.ExpressionConverter;
import org.immutables.criteria.expression.ExpressionVisitor;
import org.immutables.criteria.mongo.FindVisitor;

final class Mongos {
    static final String ID_FIELD_NAME = "_id";

    static ExpressionConverter<Bson> converter(PathNaming pathNaming, CodecRegistry codecRegistry) {
        return expression -> (Bson)expression.accept((ExpressionVisitor)new FindVisitor(pathNaming, codecRegistry));
    }

    static Bson filterById(Iterable<?> ids) {
        return Filters.in((String)ID_FIELD_NAME, ids);
    }

    static boolean isOptional(Type type) {
        return type == Optional.class || type == OptionalDouble.class || type == OptionalLong.class || type == OptionalInt.class || type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Optional.class;
    }

    private Mongos() {
    }
}

