/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonNull;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.criteria.backend.ExpressionNaming;
import org.immutables.criteria.backend.ProjectedTuple;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.mongo.Mongos;
import org.immutables.criteria.mongo.codecs.SimpleRegistry;

class TupleCodecProvider
implements CodecProvider {
    private final Query query;
    private final ExpressionNaming naming;

    TupleCodecProvider(Query query, ExpressionNaming naming) {
        this.query = Objects.requireNonNull(query, "query");
        this.naming = Objects.requireNonNull(naming, "naming");
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == ProjectedTuple.class) {
            return new TupleCodec(registry, this.query, this.naming);
        }
        return null;
    }

    private static class TupleCodec
    implements Codec<ProjectedTuple> {
        private final Query query;
        private final List<FieldDecoder> decoders;
        private final CodecRegistry registry;

        private TupleCodec(CodecRegistry registry, Query query, ExpressionNaming naming) {
            this.query = query;
            if (query.projections().isEmpty()) {
                throw new IllegalArgumentException(String.format("No projections defined in query %s", query));
            }
            this.registry = Objects.requireNonNull(registry, "registry");
            this.decoders = query.projections().stream().map(p -> new FieldDecoder((Expression)p, naming.name(p), registry)).collect(Collectors.toList());
        }

        public ProjectedTuple decode(BsonReader reader, DecoderContext context) {
            BsonDocument doc = (BsonDocument)this.registry.get(BsonDocument.class).decode(reader, context);
            ArrayList<Object> values = new ArrayList<Object>();
            for (FieldDecoder field : this.decoders) {
                BsonValue bson = TupleCodec.resolveOrNull((BsonValue)doc, Arrays.asList(field.mongoField.split("\\.")));
                values.add(field.decode(bson));
            }
            return ProjectedTuple.of((Iterable)this.query.projections(), values);
        }

        private static BsonValue resolveOrNull(BsonValue value, List<String> paths) {
            String first;
            if (paths.isEmpty()) {
                return value;
            }
            if (!value.isDocument()) {
                return BsonNull.VALUE;
            }
            BsonDocument document = value.asDocument();
            if (!document.containsKey((Object)(first = paths.get(0)))) {
                return BsonNull.VALUE;
            }
            return TupleCodec.resolveOrNull(document.get((Object)first), paths.subList(1, paths.size()));
        }

        public void encode(BsonWriter writer, ProjectedTuple value, EncoderContext encoderContext) {
            throw new UnsupportedOperationException(String.format("%s can't encode %s (only decode)", this.getClass().getSimpleName(), this.getEncoderClass().getName()));
        }

        public Class<ProjectedTuple> getEncoderClass() {
            return ProjectedTuple.class;
        }
    }

    private static class BsonValueReader
    extends BsonDocumentReader {
        private BsonValueReader(BsonValue value) {
            super(BsonValueReader.fromValue(value));
            this.readStartDocument();
            String name = this.readName();
            if (!name.equals("value")) {
                throw new IllegalStateException(String.format("Expected 'value' got %s", name));
            }
        }

        private static BsonDocument fromValue(BsonValue value) {
            return value.isDocument() ? value.asDocument() : new BsonDocument("value", value);
        }
    }

    private static class FieldDecoder {
        private final String mongoField;
        private final Decoder<?> decoder;
        private final boolean isNullable;

        private FieldDecoder(Expression expression, String name, CodecRegistry registry) {
            this.mongoField = name;
            Type type = expression.returnType();
            this.isNullable = !Mongos.isOptional(type);
            this.decoder = SimpleRegistry.of(registry).get(TypeToken.of((Type)type));
        }

        Object decode(BsonValue bson) {
            Object value = this.isNullable && bson.isNull() ? null : (!bson.isDocument() ? this.decoder.decode((BsonReader)new BsonValueReader(bson), DecoderContext.builder().build()) : this.decoder.decode((BsonReader)new BsonDocumentReader(bson.asDocument()), DecoderContext.builder().build()));
            return value;
        }
    }
}

