/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import org.bson.UuidRepresentation;
import org.bson.codecs.BigDecimalCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.ByteArrayCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DateCodec;
import org.bson.codecs.Decimal128Codec;
import org.bson.codecs.ObjectIdCodec;
import org.bson.codecs.PatternCodec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.jsr310.Jsr310CodecProvider;
import org.immutables.criteria.mongo.bson4jackson.JacksonCodecs;

public class BsonModule
extends Module {
    private final CodecRegistry registry;

    public BsonModule() {
        this(BsonModule.defaultRegistry());
    }

    private BsonModule(CodecRegistry registry) {
        this.registry = registry;
    }

    public String getModuleName() {
        return BsonModule.class.getSimpleName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    private static CodecRegistry defaultRegistry() {
        CodecRegistry standard = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider(), new Jsr310CodecProvider()});
        CodecRegistry others = CodecRegistries.fromCodecs((Codec[])new Codec[]{new ObjectIdCodec(), new DateCodec(), new UuidCodec(UuidRepresentation.JAVA_LEGACY), new Decimal128Codec(), new PatternCodec(), new BigDecimalCodec(), new ByteArrayCodec()});
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{standard, others});
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers(JacksonCodecs.serializers(this.registry));
        context.addDeserializers(JacksonCodecs.deserializers(this.registry));
    }
}

