/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.AbstractBsonReader;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.immutables.criteria.mongo.bson4jackson.Wrapper;

@NotThreadSafe
public class BsonParser
extends ParserBase
implements Wrapper<BsonReader> {
    private final AbstractBsonReader reader;
    private ParseContext context;
    private ObjectCodec _codec;

    BsonParser(IOContext ctxt, int jsonFeatures, AbstractBsonReader reader) {
        super(ctxt, jsonFeatures);
        this.reader = Objects.requireNonNull(reader, "reader");
        this.context = new ParseContext();
    }

    protected void _closeInput() throws IOException {
        if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this.reader.close();
        }
        this.context = null;
        this._closed = true;
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec codec) {
        this._codec = codec;
    }

    private AbstractBsonReader.State state() {
        return this.reader.getState();
    }

    public String nextFieldName() throws JsonParseException {
        JsonToken next = this.next();
        if (next == JsonToken.FIELD_NAME) {
            return this.context.fieldName;
        }
        return null;
    }

    public String getCurrentName() throws JsonParseException {
        if (this.state() == AbstractBsonReader.State.NAME) {
            return this.nextFieldName();
        }
        if (this.state() == AbstractBsonReader.State.VALUE) {
            return this.context.fieldName;
        }
        return null;
    }

    public Number getNumberValue() throws JsonParseException {
        if (this.currentToken() == JsonToken.VALUE_NULL) {
            throw new JsonParseException((JsonParser)this, String.format("Can't convert %s (bson:%s) to %s", this.currentToken(), this.type(), Number.class.getName()));
        }
        if (!this.context.hasValue()) {
            this.readValue();
        }
        if (this.context.value instanceof Number) {
            return (Number)this.context.value;
        }
        if (this.context.value instanceof String) {
            return new BigDecimal((String)this.context.value);
        }
        String valueType = this.context.value != null ? this.context.value.getClass().getName() : "null";
        throw new JsonParseException((JsonParser)this, String.format("Can't convert %s (as %s) to %s", this.context.value, valueType, Number.class.getName()));
    }

    private void readValue() throws JsonParseException {
        BsonType type = this.type();
        switch (type) {
            case DOUBLE: {
                this.context.setValue(this.reader.readDouble());
                break;
            }
            case INT32: {
                this.context.setValue(this.reader.readInt32());
                break;
            }
            case INT64: {
                this.context.setValue(this.reader.readInt64());
                break;
            }
            case DECIMAL128: {
                this.context.setValue(this.reader.readDecimal128().bigDecimalValue());
                break;
            }
            case DATE_TIME: {
                this.context.setValue(this.reader.readDateTime());
                break;
            }
            case TIMESTAMP: {
                this.context.setValue(this.reader.readTimestamp().getValue());
                break;
            }
            case SYMBOL: {
                this.context.setValue(this.reader.readSymbol());
                break;
            }
            case STRING: {
                this.context.setValue(this.reader.readString());
                break;
            }
            case OBJECT_ID: {
                this.context.setValue(this.reader.readObjectId().toHexString());
                break;
            }
            case REGULAR_EXPRESSION: {
                this.context.setValue(this.reader.readRegularExpression().getPattern());
                break;
            }
            case BOOLEAN: {
                this.context.setValue(this.reader.readBoolean());
                break;
            }
            case NULL: {
                this.reader.readNull();
                this.context.setValue(null);
                break;
            }
            case UNDEFINED: {
                this.reader.readUndefined();
                this.context.setValue(null);
                break;
            }
            case BINARY: {
                this.context.setValue(this.reader.readBinaryData().getData());
                break;
            }
            default: {
                throw new JsonParseException((JsonParser)this, String.format("Unknown bson type %s (as json type %s)", type, this.currentToken()));
            }
        }
    }

    public BigInteger getBigIntegerValue() throws JsonParseException {
        Number number = this.getNumberValue();
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof Byte || number instanceof Integer || number instanceof Long || number instanceof Short) {
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue()).toBigInteger();
        }
        return new BigInteger(number.toString());
    }

    public float getFloatValue() throws JsonParseException {
        return this.getNumberValue().floatValue();
    }

    public double getDoubleValue() throws JsonParseException {
        return this.getNumberValue().doubleValue();
    }

    public int getIntValue() throws JsonParseException {
        return this.getNumberValue().intValue();
    }

    public long getLongValue() throws JsonParseException {
        return this.getNumberValue().longValue();
    }

    public BigDecimal getDecimalValue() throws JsonParseException {
        Number number = this.getNumberValue();
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Byte || number instanceof Integer || number instanceof Long || number instanceof Short) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        return new BigDecimal(number.toString());
    }

    private BsonType type() {
        return this.reader.getCurrentBsonType();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        BsonType type = this.type();
        switch (type) {
            case DOUBLE: {
                return JsonParser.NumberType.DOUBLE;
            }
            case INT32: {
                return JsonParser.NumberType.INT;
            }
            case INT64: {
                return JsonParser.NumberType.LONG;
            }
            case DECIMAL128: {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
        }
        throw new JsonParseException((JsonParser)this, String.format("Not a numeric type json:%s bson%s", this.currentToken(), type));
    }

    public JsonToken nextToken() throws JsonParseException {
        this._currToken = this.next();
        return this._currToken;
    }

    private JsonToken next() throws JsonParseException {
        if (!this.context.hasValue() && this.state() == AbstractBsonReader.State.VALUE) {
            this.reader.skipValue();
        }
        this.context.reset();
        while (this.state() == AbstractBsonReader.State.TYPE) {
            this.reader.readBsonType();
        }
        switch (this.state()) {
            case INITIAL: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case NAME: {
                this.context.fieldName = this.reader.readName();
                this.context.skipValue = false;
                return JsonToken.FIELD_NAME;
            }
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case END_OF_ARRAY: {
                this.reader.readEndArray();
                return JsonToken.END_ARRAY;
            }
            case DONE: {
                return null;
            }
            case VALUE: {
                return this.readToken();
            }
        }
        throw new JsonParseException((JsonParser)this, String.format("Unexpected BSON state:%s type:%s", this.state(), this.type()));
    }

    private JsonToken readToken() throws JsonParseException {
        switch (this.type()) {
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case DOCUMENT: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case ARRAY: {
                this.reader.readStartArray();
                return JsonToken.START_ARRAY;
            }
            case BOOLEAN: {
                boolean value = this.reader.readBoolean();
                this.context.setValue(value);
                return value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case NULL: {
                this.reader.readNull();
                this.context.setValue(null);
                return JsonToken.VALUE_NULL;
            }
            case SYMBOL: 
            case STRING: {
                return JsonToken.VALUE_STRING;
            }
            case INT32: 
            case INT64: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case DOUBLE: 
            case DECIMAL128: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case UNDEFINED: {
                this.reader.readUndefined();
                this.context.setValue(null);
                return JsonToken.VALUE_NULL;
            }
        }
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    public String getText() throws JsonParseException {
        JsonToken token = this.currentToken();
        if (token == JsonToken.FIELD_NAME || this.type() == null) {
            return this.context.fieldName;
        }
        if (token == JsonToken.VALUE_NULL || token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
            return token.asString();
        }
        if (this.context.hasValue()) {
            return this.context.valueAsString();
        }
        this.readValue();
        return this.context.valueAsString();
    }

    public byte[] getBinaryValue(Base64Variant variant) throws IOException {
        if (this.type() != BsonType.BINARY) {
            throw new JsonParseException((JsonParser)this, String.format("Can't read binary data. Expected type %s got %s", BsonType.BINARY, this.type()));
        }
        if (!this.context.hasValue()) {
            this.readValue();
        }
        return (byte[])this.context.value;
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public BsonReader unwrap() {
        return this.reader;
    }

    private static class ParseContext {
        private String fieldName;
        private Object value;
        private boolean skipValue;

        private ParseContext() {
        }

        private String valueAsString() {
            return Objects.toString(this.value);
        }

        private void setValue(Object value) {
            this.value = value;
            this.skipValue = false;
        }

        private boolean hasValue() {
            return !this.skipValue;
        }

        private void reset() {
            this.value = null;
            this.skipValue = true;
        }
    }
}

