/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.immutables.criteria.Criteria;

public class IdAnnotationModule
extends Module {
    private static final Class<Criteria.Id> DEFAULT_ID_ANNOTATION = Criteria.Id.class;
    private final Predicate<? super AnnotatedElement> predicate;

    public IdAnnotationModule() {
        this(a -> a.isAnnotationPresent(DEFAULT_ID_ANNOTATION));
    }

    private IdAnnotationModule(Predicate<? super AnnotatedElement> predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    public static IdAnnotationModule fromAnnotation(Class<? extends Annotation> annotation) {
        Objects.requireNonNull(annotation, "annotation");
        return IdAnnotationModule.fromPredicate(m -> m instanceof AnnotatedElement && ((AnnotatedElement)((Object)m)).isAnnotationPresent(annotation));
    }

    public static IdAnnotationModule fromPredicate(Predicate<? super Member> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Predicate<AnnotatedElement> newPred = a -> a instanceof Member && predicate.test((Member)((Object)a));
        return new IdAnnotationModule(newPred);
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.insertAnnotationIntrospector((AnnotationIntrospector)new IdAnnotationIntrospector(this.predicate));
    }

    private static class IdAnnotationIntrospector
    extends NopAnnotationIntrospector {
        private final Predicate<? super AnnotatedElement> predicate;

        IdAnnotationIntrospector(Predicate<? super AnnotatedElement> predicate) {
            this.predicate = Objects.requireNonNull(predicate, "predicate");
        }

        public PropertyName findNameForDeserialization(Annotated annotated) {
            return this.derivePropertyName(annotated);
        }

        public PropertyName findNameForSerialization(Annotated annotated) {
            return this.derivePropertyName(annotated);
        }

        private PropertyName derivePropertyName(Annotated annotated) {
            return this.findOriginalMethod(annotated.getAnnotated()).map(m -> PropertyName.construct((String)"_id")).orElse(null);
        }

        private Optional<AnnotatedElement> findOriginalMethod(AnnotatedElement annotated) {
            if (annotated != null && this.predicate.test(annotated)) {
                return Optional.of(annotated);
            }
            if (annotated instanceof Field) {
                Field field = (Field)annotated;
                Optional<Method> maybe = Arrays.stream(field.getDeclaringClass().getMethods()).filter(m -> m.getParameterCount() == 0).filter(m -> m.getName().equals(field.getName())).findAny();
                return maybe.flatMap(this::findOriginalMethod);
            }
            if (!(annotated instanceof Method)) {
                return Optional.empty();
            }
            Method method = (Method)annotated;
            if (this.predicate.test(method)) {
                return Optional.of(method);
            }
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            for (Class iface : TypeToken.of(method.getDeclaringClass()).getTypes().interfaces().rawTypes()) {
                try {
                    Method maybe = iface.getMethod(name, params);
                    if (!this.predicate.test(maybe)) continue;
                    return Optional.of(maybe);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return Optional.empty();
        }
    }
}

