/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.bson.AbstractBsonReader;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.criteria.mongo.bson4jackson.BsonGenerator;
import org.immutables.criteria.mongo.bson4jackson.BsonParser;
import org.immutables.criteria.mongo.bson4jackson.LegacyCodecAdapter;

class JacksonCodecRegistry
implements CodecRegistry {
    private final ObjectMapper mapper;

    private JacksonCodecRegistry(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public static JacksonCodecRegistry of(ObjectMapper mapper) {
        return new JacksonCodecRegistry(mapper);
    }

    public <T> Codec<T> get(Class<T> clazz) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(clazz);
        if (!this.mapper.canSerialize(clazz) || !this.mapper.canDeserialize(javaType)) {
            throw new CodecConfigurationException(String.format("%s (javaType: %s) not supported by Jackson Mapper", clazz, javaType));
        }
        return new JacksonCodec<T>(clazz, this.mapper);
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry codecRegistry) {
        return LegacyCodecAdapter.of(this).get(clazz, codecRegistry);
    }

    private static class JacksonCodec<T>
    implements Codec<T> {
        private final Class<T> clazz;
        private final ObjectReader reader;
        private final ObjectWriter writer;
        private final IOContext ioContext;

        JacksonCodec(Class<T> clazz, ObjectMapper mapper) {
            this.clazz = Objects.requireNonNull(clazz, "clazz");
            Objects.requireNonNull(mapper, "mapper");
            this.reader = mapper.readerFor(clazz);
            this.writer = mapper.writerFor(clazz);
            this.ioContext = new IOContext(new BufferRecycler(), ContentReference.unknown(), false);
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            Preconditions.checkArgument((boolean)(reader instanceof AbstractBsonReader), (String)"Expected reader to be %s for %s but was %s", (Object)AbstractBsonReader.class.getName(), this.clazz, reader.getClass());
            BsonParser parser = new BsonParser(this.ioContext, 0, (AbstractBsonReader)reader);
            try {
                return (T)this.reader.readValue((JsonParser)parser);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error while decoding " + this.clazz, e);
            }
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            BsonGenerator generator = new BsonGenerator(0, writer);
            try {
                this.writer.writeValue((JsonGenerator)generator, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Couldn't serialize [" + value + "] as " + this.getEncoderClass(), e);
            }
        }

        public Class<T> getEncoderClass() {
            return this.clazz;
        }
    }
}

