/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.function.Predicate;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.criteria.mongo.bson4jackson.BsonGenerator;
import org.immutables.criteria.mongo.bson4jackson.JacksonCodecRegistry;
import org.immutables.criteria.mongo.bson4jackson.NativeCodecRegistry;
import org.immutables.criteria.mongo.bson4jackson.Wrapper;

@Beta
public final class JacksonCodecs {
    private static final Predicate<JavaType> IS_BSON_TYPE = type -> {
        Class raw = type.getRawClass();
        return BsonValue.class.isAssignableFrom(raw) || Document.class.isAssignableFrom(raw) || Bson.class.isAssignableFrom(raw);
    };

    public static CodecRegistry registryFromMapper(ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{new NativeCodecRegistry(mapper), JacksonCodecRegistry.of(mapper)});
    }

    private static <T> Codec<T> findCodecOrNull(CodecRegistry registry, Class<T> type) {
        try {
            return registry.get(type);
        }
        catch (CodecConfigurationException e) {
            return null;
        }
    }

    private static <T> JsonSerializer<T> serializer(Codec<T> codec) {
        Objects.requireNonNull(codec, "codec");
        return new CodecSerializer(codec);
    }

    private static <T> JsonDeserializer<T> deserializer(final Codec<T> codec) {
        Objects.requireNonNull(codec, "codec");
        return new JsonDeserializer<T>(){

            public T deserialize(JsonParser parser, DeserializationContext ctxt) {
                BsonReader reader = (BsonReader)((Wrapper)parser).unwrap();
                return codec.decode(reader, DecoderContext.builder().build());
            }
        };
    }

    static Serializers serializers(final CodecRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        return new Serializers.Base(){

            public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
                try {
                    Codec codec = registry.get(type.getRawClass());
                    return JacksonCodecs.serializer(codec);
                }
                catch (CodecConfigurationException e) {
                    return null;
                }
            }

            public JsonSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
                if (IS_BSON_TYPE.test(type)) {
                    Codec codec = JacksonCodecs.findCodecOrNull(registry, type.getRawClass());
                    return codec == null ? null : JacksonCodecs.serializer(codec);
                }
                return null;
            }
        };
    }

    static Deserializers deserializers(final CodecRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        return new Deserializers.Base(){

            public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                Codec codec = JacksonCodecs.findCodecOrNull(registry, type.getRawClass());
                return codec == null ? null : JacksonCodecs.deserializer(codec);
            }

            public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
                if (IS_BSON_TYPE.test(type)) {
                    Codec codec = JacksonCodecs.findCodecOrNull(registry, type.getRawClass());
                    return codec == null ? null : JacksonCodecs.deserializer(codec);
                }
                return null;
            }
        };
    }

    public static Module module(CodecProvider provider) {
        return JacksonCodecs.module(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{provider}));
    }

    private static Module module(final CodecRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        return new Module(){

            public String getModuleName() {
                return JacksonCodecs.class.getSimpleName();
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.addSerializers(JacksonCodecs.serializers(registry));
                context.addDeserializers(JacksonCodecs.deserializers(registry));
            }

            public Object getTypeId() {
                return null;
            }
        };
    }

    private JacksonCodecs() {
    }

    static class CodecSerializer<T>
    extends StdSerializer<T>
    implements Wrapper<Codec<T>> {
        private final Codec<T> codec;

        private CodecSerializer(Codec<T> codec) {
            super(codec.getEncoderClass());
            this.codec = Objects.requireNonNull(codec, "codec");
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) {
            BsonWriter writer = ((BsonGenerator)gen).unwrap();
            this.codec.encode(writer, value, EncoderContext.builder().build());
        }

        @Override
        public Codec<T> unwrap() {
            return this.codec;
        }
    }
}

