/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.Annotations;
import com.google.common.annotations.Beta;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.expression.Path;

@Beta
public class JacksonPathNaming
implements PathNaming {
    private final ObjectMapper mapper;

    public JacksonPathNaming(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public String name(Path path) {
        ArrayList<String> names = new ArrayList<String>();
        Type enclosingType = (Class)path.root().element();
        for (Member member : path.members()) {
            BeanDescription description;
            JavaType javaType = this.mapper.getTypeFactory().constructType(enclosingType);
            if (javaType.isCollectionLikeType() || javaType.isTypeOrSubTypeOf(Optional.class)) {
                javaType = (JavaType)javaType.getBindings().getTypeParameters().get(0);
            }
            if ((description = this.mapper.getSerializationConfig().introspect(javaType)).findProperties().isEmpty()) {
                description = this.findImmutableClassDefinition(javaType);
            }
            Optional<BeanPropertyDefinition> def = Stream.of(description).flatMap(x -> x.findProperties().stream()).filter(x -> x.getPrimaryMember() != null && member.equals(x.getPrimaryMember().getMember())).findAny();
            String name = def.map(BeanPropertyDefinition::getName).orElse(member.getName());
            names.add(name);
            if (member instanceof Field) {
                enclosingType = ((Field)member).getGenericType();
                continue;
            }
            if (member instanceof Method) {
                enclosingType = ((Method)member).getGenericReturnType();
                continue;
            }
            enclosingType = member.getDeclaringClass();
        }
        return String.join((CharSequence)".", names);
    }

    BeanDescription findImmutableClassDefinition(JavaType type) {
        Annotations annot = this.mapper.getSerializationConfig().introspect(type).getClassAnnotations();
        JsonSerialize ser = (JsonSerialize)annot.get(JsonSerialize.class);
        JavaType newType = this.mapper.getTypeFactory().constructType((Type)ser.as());
        return this.mapper.getSerializationConfig().introspect(newType);
    }
}

