/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import java.util.Objects;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

class LegacyCodecAdapter
implements CodecProvider {
    private final CodecRegistry delegate;

    private LegacyCodecAdapter(CodecRegistry delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        try {
            return this.delegate.get(clazz);
        }
        catch (CodecConfigurationException e) {
            return null;
        }
    }

    static CodecProvider of(CodecRegistry registry) {
        return new LegacyCodecAdapter(registry);
    }
}

