/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.bson4jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.criteria.mongo.bson4jackson.LegacyCodecAdapter;
import org.immutables.criteria.mongo.bson4jackson.Wrapper;

class NativeCodecRegistry
implements CodecRegistry {
    private final ObjectMapper mapper;

    NativeCodecRegistry(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public <T> Codec<T> get(Class<T> clazz) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(clazz);
        try {
            JsonSerializer ser = this.mapper.getSerializerProviderInstance().findValueSerializer(javaType);
            if (ser instanceof Wrapper) {
                Codec codec = (Codec)((Wrapper)ser).unwrap();
                return codec;
            }
        }
        catch (JsonMappingException e) {
            throw new CodecConfigurationException("Exception for " + javaType, (Throwable)e);
        }
        throw new CodecConfigurationException(javaType + " not supported");
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return LegacyCodecAdapter.of(this).get(clazz, registry);
    }
}

