/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.codecs;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.immutables.criteria.mongo.codecs.TypedProvider;
import org.immutables.criteria.mongo.codecs.TypedRegistry;

class OptionalProvider
implements TypedProvider {
    OptionalProvider() {
    }

    @Override
    public <T> Codec<T> get(TypeToken<T> token, TypedRegistry registry) {
        if (token.getRawType().equals(Optional.class) && token.getType() instanceof ParameterizedType) {
            TypeToken newType = TypeToken.of((Type)((ParameterizedType)token.getType()).getActualTypeArguments()[0]);
            Codec delegate = registry.get(newType);
            return new OptionalCodec(token.getRawType(), delegate);
        }
        if (token.getRawType().equals(com.google.common.base.Optional.class) && token.getType() instanceof ParameterizedType) {
            TypeToken newType = TypeToken.of((Type)((ParameterizedType)token.getType()).getActualTypeArguments()[0]);
            Codec delegate = registry.get(newType);
            return new GuavaCodec(token.getRawType(), delegate);
        }
        return null;
    }

    private static class OptionalCodec<T>
    extends AbstractOptional<T, Optional<T>> {
        private OptionalCodec(Class<Optional<T>> encoderClass, Codec<T> delegate) {
            super(encoderClass, delegate);
        }

        @Override
        Optional<T> empty() {
            return Optional.empty();
        }

        @Override
        Optional<T> nullable(T value) {
            return Optional.ofNullable(value);
        }
    }

    private static class GuavaCodec<T>
    extends AbstractOptional<T, com.google.common.base.Optional<T>> {
        private GuavaCodec(Class<com.google.common.base.Optional<T>> encoderClass, Codec<T> delegate) {
            super(encoderClass, delegate);
        }

        @Override
        com.google.common.base.Optional<T> empty() {
            return com.google.common.base.Optional.absent();
        }

        @Override
        com.google.common.base.Optional<T> nullable(T value) {
            return com.google.common.base.Optional.fromNullable(value);
        }
    }

    private static abstract class AbstractOptional<T, O>
    implements Codec<O> {
        private final Class<O> encoderClass;
        private final Codec<T> delegate;

        private AbstractOptional(Class<O> encoderClass, Codec<T> delegate) {
            this.encoderClass = encoderClass;
            this.delegate = delegate;
        }

        public final O decode(BsonReader reader, DecoderContext decoderContext) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                return this.empty();
            }
            return this.nullable(this.delegate.decode(reader, decoderContext));
        }

        public final void encode(BsonWriter writer, O value, EncoderContext encoderContext) {
            throw new UnsupportedOperationException("Not yet supported");
        }

        public Class<O> getEncoderClass() {
            return this.encoderClass;
        }

        abstract O empty();

        abstract O nullable(T var1);
    }
}

