/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.mongo.codecs;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.criteria.mongo.codecs.FallbackProvider;
import org.immutables.criteria.mongo.codecs.OptionalProvider;
import org.immutables.criteria.mongo.codecs.TypedProvider;
import org.immutables.criteria.mongo.codecs.TypedRegistry;

public class SimpleRegistry
implements TypedRegistry {
    private final CodecRegistry registry;
    private final List<TypedProvider> providers;

    private SimpleRegistry(CodecRegistry registry) {
        this.registry = registry;
        this.providers = ImmutableList.of((Object)new OptionalProvider(), (Object)new FallbackProvider(registry));
    }

    @Override
    public <T> Codec<T> get(TypeToken<T> type) {
        for (TypedProvider provider : this.providers) {
            Codec<T> codec = provider.get(type, this);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }

    public static TypedRegistry of(CodecRegistry registry) {
        return new SimpleRegistry(registry);
    }
}

