/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import org.immutables.generator.ExtensionLoader;

public final class ClasspathFence {
    private static final Supplier<ImmutableSet<String>> BLOCKED = ExtensionLoader.findExtensions("META-INF/extensions/org.immutables.inhibit-classpath");

    private ClasspathFence() {
    }

    public static boolean isInhibited(String classname) {
        for (String prefix : (ImmutableSet)BLOCKED.get()) {
            if (!classname.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

