/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.immutables.generator.ClasspathAvailability;
import org.immutables.generator.Intrinsics;
import org.immutables.generator.Output;
import org.immutables.generator.StaticEnvironment;
import org.immutables.generator.StringLiterals;
import org.immutables.generator.Templates;

public class Builtins {
    public final boolean $$true = true;
    public final boolean $$false = false;
    public final Void $$null = null;
    public final Output output = new Output();
    public final ClasspathAvailability classpath = new ClasspathAvailability();
    public final Predicate<Object> not = new Predicate<Object>(){

        public boolean apply(Object input) {
            return !Intrinsics.$if(input);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".not";
        }
    };
    public final Predicate<Object> singular = new Predicate<Object>(){

        public boolean apply(Object input) {
            return (Integer)Builtins.this.size.apply(input) == 1;
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".singular";
        }
    };
    public final Function<Object, Integer> size = new Function<Object, Integer>(){

        public Integer apply(Object input) {
            if (input instanceof Map) {
                return ((Map)input).size();
            }
            if (input instanceof Iterable) {
                return Iterables.size((Iterable)((Iterable)input));
            }
            if (input instanceof CharSequence) {
                return ((CharSequence)input).length();
            }
            return 1;
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".size";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> eq = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            if (left instanceof String || right instanceof String) {
                return String.valueOf(left).equals(String.valueOf(right));
            }
            return Objects.equals(left, right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".eq";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> eqref = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return left == right;
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".eq";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> ne = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return Builtins.this.eq.apply(left, right) == false;
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".ne";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> and = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return Intrinsics.$if(left) && Intrinsics.$if(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".and";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> andnot = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return Intrinsics.$if(left) && !Intrinsics.$if(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".andnot";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> or = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return Intrinsics.$if(left) || Intrinsics.$if(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".or";
        }
    };
    public final Templates.Binary<Object, Object, Boolean> ornot = new Templates.Binary<Object, Object, Boolean>(){

        @Override
        public Boolean apply(Object left, Object right) {
            return Intrinsics.$if(left) || !Intrinsics.$if(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".ornot";
        }
    };
    public final Templates.Binary<Object, String, Boolean> startsWith = new Templates.Binary<Object, String, Boolean>(){

        @Override
        public Boolean apply(Object left, String right) {
            return left.toString().startsWith(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".startsWith";
        }
    };
    public final Templates.Binary<Object, String, Boolean> endsWith = new Templates.Binary<Object, String, Boolean>(){

        @Override
        public Boolean apply(Object left, String right) {
            return left.toString().endsWith(right);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".endsWith";
        }
    };
    public final Templates.Binary<Object, Collection<?>, Boolean> in = new Templates.Binary<Object, Collection<?>, Boolean>(){

        @Override
        public Boolean apply(Object left, Collection<?> right) {
            return right.contains(left);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".in";
        }
    };
    public final Templates.Binary<Object, Collection<?>, Boolean> notin = new Templates.Binary<Object, Collection<?>, Boolean>(){

        @Override
        public Boolean apply(Object left, Collection<?> right) {
            return !right.contains(left);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".right";
        }
    };
    public final Literal literal = new Literal();
    public final Function<Integer, String> emptyIfZero = new Function<Integer, String>(){

        public String apply(Integer input) {
            return input == 0 ? "" : input.toString();
        }
    };
    public final Function<Object, String> toUpper = Functions.compose((Function)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_CAMEL), (Function)Functions.toStringFunction());
    public final Function<Object, String> toLower = Functions.compose((Function)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL), (Function)Functions.toStringFunction());
    public final Function<Object, String> toConstant = Functions.compose((Function)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE), (Function)Functions.toStringFunction());
    public final Function<Object, String> toSafeIdentifier = new Function<Object, String>(){
        private final CharMatcher digits = CharMatcher.inRange((char)'0', (char)'9');
        private final CharMatcher nonIdentifierChars = CharMatcher.is((char)'_').or(this.digits).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).negate();

        public String apply(Object input) {
            String inputString = String.valueOf(input);
            if (inputString.isEmpty()) {
                return "_";
            }
            String safeString = this.nonIdentifierChars.replaceFrom((CharSequence)inputString, '_');
            if (this.digits.matches(safeString.charAt(0))) {
                return "_" + safeString;
            }
            return safeString;
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".toSafeIdentifier";
        }
    };

    public static final class Literal
    implements Function<Object, String> {
        public final Function<Object, String> string = new Function<Object, String>(){

            public String apply(Object input) {
                return StringLiterals.toLiteral(String.valueOf(input));
            }
        };
        public final Function<Number, String> hex = new Function<Number, String>(){

            public String apply(Number input) {
                if (input instanceof Long) {
                    return "0x" + Long.toHexString(input.longValue()) + "L";
                }
                if (input instanceof Integer) {
                    return "0x" + Integer.toHexString(input.intValue());
                }
                throw new IllegalArgumentException("unsupported non integer or long " + input);
            }

            public String toString() {
                return Literal.this.toString() + ".hex";
            }
        };
        public final Function<Number, String> bin = new Function<Number, String>(){

            public String apply(Number input) {
                if (input instanceof Long) {
                    return "0b" + Long.toBinaryString(input.longValue()) + "L";
                }
                if (input instanceof Integer) {
                    return "0b" + Integer.toBinaryString(input.intValue());
                }
                throw new IllegalArgumentException("unsupported non integer or long " + input);
            }

            public String toString() {
                return Literal.this.toString() + ".bin";
            }
        };

        public String apply(Object input) {
            return StaticEnvironment.processing().getElementUtils().getConstantExpression(input);
        }

        public String toString() {
            return Builtins.class.getSimpleName() + ".literal";
        }
    }
}

