/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.annotation.processing.Filer;
import javax.tools.StandardLocation;
import org.immutables.generator.StaticEnvironment;

public final class ExtensionLoader {
    private static final Splitter RESOURCE_SPLITTER = Splitter.on((String)"\n").omitEmptyStrings().trimResults();

    private ExtensionLoader() {
    }

    public static Supplier<ImmutableSet<String>> findExtensions(final String resource) {
        return Suppliers.memoize((Supplier)new Supplier<ImmutableSet<String>>(){

            public ImmutableSet<String> get() {
                ArrayList extensions = Lists.newArrayList();
                if (StaticEnvironment.isInitialized()) {
                    try {
                        String lines = ExtensionLoader.getClasspathResourceText(StaticEnvironment.processing().getFiler(), resource);
                        extensions.addAll(RESOURCE_SPLITTER.splitToList((CharSequence)lines));
                    }
                    catch (IOException | RuntimeException lines) {
                        // empty catch block
                    }
                }
                ClassLoader classLoader = ExtensionLoader.class.getClassLoader();
                try {
                    Enumeration<URL> resources = classLoader.getResources(resource);
                    while (resources.hasMoreElements()) {
                        URL nextElement = resources.nextElement();
                        String lines = ExtensionLoader.getClasspathResourceText(nextElement);
                        extensions.addAll(RESOURCE_SPLITTER.splitToList((CharSequence)lines));
                    }
                }
                catch (IOException | RuntimeException exception) {
                    // empty catch block
                }
                return FluentIterable.from((Iterable)extensions).toSet();
            }
        });
    }

    private static String getClasspathResourceText(Filer filer, String resourceName) throws IOException {
        return filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceName).getCharContent(true).toString();
    }

    private static String getClasspathResourceText(URL requestURL) throws IOException {
        URLConnection connection = requestURL.openConnection();
        connection.setUseCaches(false);
        try (InputStreamReader r = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
            String string = CharStreams.toString((Readable)r);
            return string;
        }
    }
}

