/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.immutables.gson.stream.JsonGeneratorWriter;
import org.immutables.gson.stream.JsonParserReader;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class GsonMessageBodyProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final Gson gson;
    private final Set<MediaType> mediaTypes;
    private final Streamer streamer;

    public GsonMessageBodyProvider() {
        this(GsonMessageBodyProvider.createGson(), true, new MediaType[0]);
    }

    public GsonMessageBodyProvider(Gson gson, boolean allowJacksonIfAvailable, MediaType ... mediaTypes) {
        this.gson = gson;
        this.mediaTypes = GsonMessageBodyProvider.mediaSetFrom(mediaTypes);
        this.streamer = GsonMessageBodyProvider.createStreamer(allowJacksonIfAvailable);
    }

    private static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        for (TypeAdapterFactory factory : ServiceLoader.load(TypeAdapterFactory.class)) {
            gsonBuilder.registerTypeAdapterFactory(factory);
        }
        return gsonBuilder.create();
    }

    private static Streamer createStreamer(boolean allowJacksonIfAvailable) {
        if (allowJacksonIfAvailable) {
            try {
                return new JacksonStreamer();
            }
            catch (Throwable ex) {
                System.err.println(ex.toString());
            }
        }
        return new GsonStreamer();
    }

    private static Set<MediaType> mediaSetFrom(MediaType[] mediaTypes) {
        if (mediaTypes.length == 0) {
            return Collections.singleton(MediaType.APPLICATION_JSON_TYPE);
        }
        return new HashSet<MediaType>(Arrays.asList(mediaTypes));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.mediaTypes.contains(mediaType);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.mediaTypes.contains(mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.streamer.write(this.gson, genericType, t, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.streamer.read(this.gson, genericType, entityStream);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                String json = this.gson.toJson((Object)new Error(ex.getCause().getMessage()));
                throw new WebApplicationException(Response.status((int)400).type(mediaType).entity((Object)json).build());
            }
            throw ex;
        }
    }

    private static class JacksonStreamer
    implements Streamer {
        private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);

        private JacksonStreamer() {
        }

        @Override
        public void write(Gson gson, Type type, Object object, OutputStream stream) throws IOException {
            JsonGeneratorWriter writer = null;
            boolean wasOriginalException = false;
            try {
                writer = new JsonGeneratorWriter(JSON_FACTORY.createGenerator(stream));
                gson.toJson(object, type, (JsonWriter)writer);
            }
            catch (IOException ex) {
                wasOriginalException = true;
                throw ex;
            }
            catch (Exception ex) {
                wasOriginalException = true;
                throw new IOException(ex);
            }
            finally {
                block12: {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ex) {
                            if (wasOriginalException) break block12;
                            throw ex;
                        }
                    }
                }
            }
        }

        @Override
        public Object read(Gson gson, Type type, InputStream stream) throws IOException {
            JsonParserReader reader = null;
            try {
                reader = new JsonParserReader(JSON_FACTORY.createParser(stream));
                Object object = gson.fromJson((JsonReader)reader, type);
                return object;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    private static class GsonStreamer
    implements Streamer {
        private static final String CHARSET_NAME = "utf-8";

        private GsonStreamer() {
        }

        @Override
        public void write(Gson gson, Type type, Object object, OutputStream stream) throws IOException {
            JsonWriter writer = null;
            boolean wasOriginalException = false;
            try {
                writer = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(stream, CHARSET_NAME)));
                gson.toJson(object, type, writer);
            }
            catch (IOException ex) {
                wasOriginalException = true;
                throw ex;
            }
            catch (Exception ex) {
                wasOriginalException = true;
                throw new IOException(ex);
            }
            finally {
                block12: {
                    if (writer != null) {
                        try {
                            writer.flush();
                        }
                        catch (IOException ex) {
                            if (wasOriginalException) break block12;
                            throw ex;
                        }
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object read(Gson gson, Type type, InputStream stream) throws IOException {
            JsonReader reader = null;
            try {
                reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream, CHARSET_NAME)));
                return gson.fromJson(reader, type);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    private static interface Streamer {
        public void write(Gson var1, Type var2, Object var3, OutputStream var4) throws IOException;

        public Object read(Gson var1, Type var2, InputStream var3) throws IOException;
    }

    static class Error {
        final String error;

        Error(String error) {
            this.error = error;
        }
    }
}

