/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonGeneratorWriter
extends JsonWriter {
    private static final Writer UNSUPPORTED_WRITER = new Writer(){

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    private final JsonGenerator generator;

    public JsonGeneratorWriter(JsonGenerator generator) {
        super(UNSUPPORTED_WRITER);
        this.generator = generator;
    }

    public JsonWriter beginArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public JsonWriter endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public JsonWriter name(String name) throws IOException {
        this.generator.writeFieldName(name);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        this.generator.writeString(value);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        if (!this.isLenient() && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.generator.writeNumber(value);
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        double d = value.doubleValue();
        if (!this.isLenient() && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + value);
        }
        this.generator.writeNumber(d);
        return this;
    }

    public void flush() throws IOException {
        this.generator.flush();
    }

    public void close() throws IOException {
        this.generator.close();
    }
}

