/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class JsonParserReader
extends JsonReader
implements Callable<JsonParser> {
    private static final Reader UNSUPPORTED_READER = new Reader(){

        @Override
        public int read(char[] buffer, int offset, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    };
    private final JsonParser parser;
    @Nullable
    private com.fasterxml.jackson.core.JsonToken peek;

    public JsonParserReader(JsonParser parser) {
        super(UNSUPPORTED_READER);
        this.parser = parser;
    }

    public JsonParser getParser() {
        return this.parser;
    }

    private void clearPeek() {
        this.peek = null;
    }

    private void requirePeek() throws IOException {
        if (this.peek == null) {
            this.peek = this.parser.nextToken();
        }
    }

    public void beginArray() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.START_ARRAY);
        this.clearPeek();
    }

    public void endArray() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.END_ARRAY);
        this.clearPeek();
    }

    public void beginObject() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.START_OBJECT);
        this.clearPeek();
    }

    public void endObject() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.END_OBJECT);
        this.clearPeek();
    }

    public boolean hasNext() throws IOException {
        this.requirePeek();
        com.fasterxml.jackson.core.JsonToken token = this.peek;
        return token != com.fasterxml.jackson.core.JsonToken.END_OBJECT & token != com.fasterxml.jackson.core.JsonToken.END_ARRAY;
    }

    public JsonToken peek() throws IOException {
        this.requirePeek();
        return JsonParserReader.toGsonToken(this.peek);
    }

    private void expect(com.fasterxml.jackson.core.JsonToken expected) {
        if (this.peek != expected) {
            throw new IllegalStateException("Expected " + expected + " but was " + this.peek);
        }
    }

    public String nextName() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.FIELD_NAME);
        String name = this.parser.getText();
        this.clearPeek();
        return name;
    }

    public String nextString() throws IOException {
        this.requirePeek();
        if (!this.isLenient()) {
            this.expect(com.fasterxml.jackson.core.JsonToken.VALUE_STRING);
        }
        String value = this.parser.getText();
        this.clearPeek();
        return value;
    }

    public boolean nextBoolean() throws IOException {
        this.requirePeek();
        boolean value = this.parser.getBooleanValue();
        this.clearPeek();
        return value;
    }

    public void nextNull() throws IOException {
        this.requirePeek();
        this.expect(com.fasterxml.jackson.core.JsonToken.VALUE_NULL);
        this.clearPeek();
    }

    public double nextDouble() throws IOException {
        this.requirePeek();
        double value = this.parser.getDoubleValue();
        this.clearPeek();
        return value;
    }

    public long nextLong() throws IOException {
        this.requirePeek();
        long value = this.parser.getLongValue();
        this.clearPeek();
        return value;
    }

    public int nextInt() throws IOException {
        this.requirePeek();
        int value = this.parser.getIntValue();
        this.clearPeek();
        return value;
    }

    public void close() throws IOException {
        this.clearPeek();
        this.parser.close();
    }

    public void skipValue() throws IOException {
        this.requirePeek();
        this.parser.skipChildren();
        this.clearPeek();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.parser.getCurrentLocation() + ")";
    }

    public void promoteNameToValue() {
        throw new UnsupportedOperationException();
    }

    private static JsonToken toGsonToken(com.fasterxml.jackson.core.JsonToken token) {
        switch (token) {
            case START_ARRAY: {
                return JsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case START_OBJECT: {
                return JsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case FIELD_NAME: {
                return JsonToken.NAME;
            }
            case VALUE_FALSE: {
                return JsonToken.BOOLEAN;
            }
            case VALUE_TRUE: {
                return JsonToken.BOOLEAN;
            }
            case VALUE_NULL: {
                return JsonToken.NULL;
            }
            case VALUE_NUMBER_INT: {
                return JsonToken.NUMBER;
            }
            case VALUE_NUMBER_FLOAT: {
                return JsonToken.NUMBER;
            }
            case VALUE_STRING: {
                return JsonToken.STRING;
            }
        }
        return JsonToken.NULL;
    }

    @Override
    public JsonParser call() throws Exception {
        return this.parser;
    }

    public final TokenBuffer nextTokenBuffer() throws IOException {
        TokenBuffer buffer = new TokenBuffer(this.parser);
        this.requirePeek();
        buffer.copyCurrentStructure(this.parser);
        this.clearPeek();
        return buffer;
    }

    protected final void consumePeek() {
        this.clearPeek();
    }
}

