package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;

/**
 * Builds instances of {@link org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
 * Initialize attributes and then invoke {@link #build()} method to create
 * immutable instance.
 * <p><em>GsonProviderOptionsBuilder is not thread safe and generally should not be stored in field or collection,
 * but used immediately to create instances.</em>
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GsonMessageBodyProvider.GsonProviderOptions"})
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
  private static final long NONDEFAULT_BIT_ALLOW_JACKSON = 0x1L;
  private static final long NONDEFAULT_BIT_LENIENT = 0x2L;
  private long nondefaultBitset;
  private @Nullable Gson gson;
  private boolean allowJackson;
  private boolean lenient;
  private ArrayList<MediaType> mediaTypesBuilder = new ArrayList<MediaType>();

  /**
   * Fill builder with attribute values from provided {@link GsonMessageBodyProvider.GsonProviderOptions} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Instance's absent optional values will not be copied (will not override current).
   * Collection elements and entries will be added, not replaced.
   * @param instance instance to copy values from
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder from(org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions instance) {
    Objects.requireNonNull(instance);
    gson(instance.gson());
    allowJackson(instance.allowJackson());
    lenient(instance.lenient());
    addAllMediaTypes(instance.mediaTypes());
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}.</em>
   * @param gson value for gson
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder gson(Gson gson) {
    this.gson = Objects.requireNonNull(gson);
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}.</em>
   * @param allowJackson value for allowJackson
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
    this.allowJackson = allowJackson;
    nondefaultBitset |= NONDEFAULT_BIT_ALLOW_JACKSON;
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}.</em>
   * @param lenient value for lenient
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder lenient(boolean lenient) {
    this.lenient = lenient;
    nondefaultBitset |= NONDEFAULT_BIT_LENIENT;
    return this;
  }

  /**
   * Adds one element to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param element mediaTypes element
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
    mediaTypesBuilder.add(Objects.requireNonNull(element));
    return this;
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements array of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType... elements) {
    for (MediaType element : elements) {
      mediaTypesBuilder.add(Objects.requireNonNull(element));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements iterable of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
    mediaTypesBuilder = new ArrayList<MediaType>();
    return addAllMediaTypes(elements);
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements iterable of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
    for (MediaType element : elements) {
      mediaTypesBuilder.add(Objects.requireNonNull(element));
    }
    return this;
  }

  /**
   * Builds new {@link org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
   * @return immutable instance of GsonProviderOptions
   */
  public org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions build() {
    return GsonProviderOptionsBuilder.ImmutableGsonProviderOptions.validate(new GsonProviderOptionsBuilder.ImmutableGsonProviderOptions(this));
  }

  private boolean allowJacksonIsSet() {
    return (nondefaultBitset & NONDEFAULT_BIT_ALLOW_JACKSON) != 0;
  }

  private boolean lenientIsSet() {
    return (nondefaultBitset & NONDEFAULT_BIT_LENIENT) != 0;
  }

  /**
   * Immutable implementation of {@link GsonMessageBodyProvider.GsonProviderOptions}.
   * <p>
   * Use builder to create immutable instances:
   * {@code new GsonProviderOptionsBuilder()}.
   * Use static factory method to get default singleton instance:
   * {@code GsonProviderOptionsBuilder.ImmutableGsonProviderOptions.of()}.
   */
  @Immutable
  private static final class ImmutableGsonProviderOptions
      extends org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions {
    private final Gson gson;
    private final boolean allowJackson;
    private final boolean lenient;
    private final List<MediaType> mediaTypes;

    private ImmutableGsonProviderOptions() {
      this.mediaTypes = Collections.emptyList();
      this.gson = Objects.requireNonNull(super.gson());
      this.allowJackson = super.allowJackson();
      this.lenient = super.lenient();
    }

    private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
      this.mediaTypes = createUnmodifiableList(true, builder.mediaTypesBuilder);
      this.gson = builder.gson != null
          ? builder.gson
          : Objects.requireNonNull(super.gson());
      this.allowJackson = builder.allowJacksonIsSet()
          ? builder.allowJackson
          : super.allowJackson();
      this.lenient = builder.lenientIsSet()
          ? builder.lenient
          : super.lenient();
    }

    /**
     * @return value of {@code gson} attribute
     */
    @Override
    public Gson gson() {
      return gson;
    }

    /**
     * @return value of {@code allowJackson} attribute
     */
    @Override
    public boolean allowJackson() {
      return allowJackson;
    }

    /**
     * @return value of {@code lenient} attribute
     */
    @Override
    public boolean lenient() {
      return lenient;
    }

    /**
     * @return value of {@code mediaTypes} attribute
     */
    @Override
    public List<MediaType> mediaTypes() {
      return mediaTypes;
    }

    /**
     * This instance is equal to instances of {@code ImmutableGsonProviderOptions} with equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another
          || (another instanceof ImmutableGsonProviderOptions && equalTo((ImmutableGsonProviderOptions) another));
    }

    private boolean equalTo(ImmutableGsonProviderOptions another) {
      return gson.equals(another.gson)
          && allowJackson == another.allowJackson
          && lenient == another.lenient
          && mediaTypes.equals(another.mediaTypes);
    }

    /**
     * Computes hash code from attributes: {@code gson}, {@code allowJackson}, {@code lenient}, {@code mediaTypes}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 31;
      h = h * 17 + gson.hashCode();
      h = h * 17 + (allowJackson ? 1231 : 1237);
      h = h * 17 + (lenient ? 1231 : 1237);
      h = h * 17 + mediaTypes.hashCode();
      return h;
    }

    /**
     * Prints immutable value {@code GsonProviderOptions{...}} with attribute values,
     * excluding any non-generated and auxiliary attributes.
     * @return string representation of value
     */
    @Override
    public String toString() {
      return new StringBuilder("GsonProviderOptions{")
          .append("gson=").append(gson)
          .append(", allowJackson=").append(allowJackson)
          .append(", lenient=").append(lenient)
          .append(", mediaTypes=").append(mediaTypes)
          .append('}').toString();
    }

    private static final ImmutableGsonProviderOptions INSTANCE = validate(new ImmutableGsonProviderOptions());

    /**
     * Returns default immutable singleton value of {@code GsonProviderOptions}
     * @return immutable instance of GsonProviderOptions
     */
    private static GsonMessageBodyProvider.GsonProviderOptions of() {
      return INSTANCE;
    }

    private static ImmutableGsonProviderOptions validate(ImmutableGsonProviderOptions instance) {
      return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }
  }

  private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
    ArrayList<T> list = iterable instanceof Collection<?>
        ? new ArrayList<T>(((Collection<?>) iterable).size())
        : new ArrayList<T>();

    for (T element : iterable) {
      list.add(Objects.requireNonNull(element, "Null in collection attribute is not allowed"));
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
