/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;
import org.immutables.gson.stream.GsonMessageBodyProvider;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
    private static final long NONDEFAULT_BIT_ALLOW_JACKSON = 1L;
    private static final long NONDEFAULT_BIT_LENIENT = 2L;
    private long nondefaultBitset;
    @Nullable
    private Gson gson;
    private boolean allowJackson;
    private boolean lenient;
    private ArrayList<MediaType> mediaTypesBuilder = new ArrayList();

    public final GsonProviderOptionsBuilder from(GsonMessageBodyProvider.GsonProviderOptions instance) {
        Objects.requireNonNull(instance);
        this.gson(instance.gson());
        this.allowJackson(instance.allowJackson());
        this.lenient(instance.lenient());
        this.addAllMediaTypes(instance.mediaTypes());
        return this;
    }

    public final GsonProviderOptionsBuilder gson(Gson gson) {
        this.gson = Objects.requireNonNull(gson);
        return this;
    }

    public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
        this.allowJackson = allowJackson;
        this.nondefaultBitset |= 1L;
        return this;
    }

    public final GsonProviderOptionsBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        this.nondefaultBitset |= 2L;
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
        this.mediaTypesBuilder.add(Objects.requireNonNull(element));
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType ... elements) {
        for (MediaType element : elements) {
            this.mediaTypesBuilder.add(Objects.requireNonNull(element));
        }
        return this;
    }

    public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
        this.mediaTypesBuilder = new ArrayList();
        return this.addAllMediaTypes(elements);
    }

    public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
        for (MediaType mediaType : elements) {
            this.mediaTypesBuilder.add(Objects.requireNonNull(mediaType));
        }
        return this;
    }

    public GsonMessageBodyProvider.GsonProviderOptions build() {
        return ImmutableGsonProviderOptions.validate(new ImmutableGsonProviderOptions(this));
    }

    private boolean allowJacksonIsSet() {
        return (this.nondefaultBitset & 1L) != 0L;
    }

    private boolean lenientIsSet() {
        return (this.nondefaultBitset & 2L) != 0L;
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "Null in collection attribute is not allowed"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Immutable
    private static final class ImmutableGsonProviderOptions
    extends GsonMessageBodyProvider.GsonProviderOptions {
        private final Gson gson;
        private final boolean allowJackson;
        private final boolean lenient;
        private final List<MediaType> mediaTypes;
        private static final ImmutableGsonProviderOptions INSTANCE = ImmutableGsonProviderOptions.validate(new ImmutableGsonProviderOptions());

        private ImmutableGsonProviderOptions() {
            this.mediaTypes = Collections.emptyList();
            this.gson = Objects.requireNonNull(super.gson());
            this.allowJackson = super.allowJackson();
            this.lenient = super.lenient();
        }

        private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
            this.mediaTypes = GsonProviderOptionsBuilder.createUnmodifiableList(true, builder.mediaTypesBuilder);
            this.gson = builder.gson != null ? builder.gson : Objects.requireNonNull(super.gson());
            this.allowJackson = builder.allowJacksonIsSet() ? builder.allowJackson : super.allowJackson();
            this.lenient = builder.lenientIsSet() ? builder.lenient : super.lenient();
        }

        @Override
        public Gson gson() {
            return this.gson;
        }

        @Override
        public boolean allowJackson() {
            return this.allowJackson;
        }

        @Override
        public boolean lenient() {
            return this.lenient;
        }

        @Override
        public List<MediaType> mediaTypes() {
            return this.mediaTypes;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof ImmutableGsonProviderOptions && this.equalTo((ImmutableGsonProviderOptions)another);
        }

        private boolean equalTo(ImmutableGsonProviderOptions another) {
            return this.gson.equals(another.gson) && this.allowJackson == another.allowJackson && this.lenient == another.lenient && this.mediaTypes.equals(another.mediaTypes);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.gson.hashCode();
            h = h * 17 + (this.allowJackson ? 1231 : 1237);
            h = h * 17 + (this.lenient ? 1231 : 1237);
            h = h * 17 + this.mediaTypes.hashCode();
            return h;
        }

        public String toString() {
            return "GsonProviderOptions{" + "gson=" + this.gson + ", allowJackson=" + this.allowJackson + ", lenient=" + this.lenient + ", mediaTypes=" + this.mediaTypes + '}';
        }

        private static GsonMessageBodyProvider.GsonProviderOptions of() {
            return INSTANCE;
        }

        private static ImmutableGsonProviderOptions validate(ImmutableGsonProviderOptions instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }
    }
}

