package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;

/**
 * Builds instances of {@link org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
 * Initialize attributes and then invoke {@link #build()} method to create
 * immutable instance.
 * <p><em>{@code GsonProviderOptionsBuilder} is not thread safe and generally should not be stored in field or collection,
 * but used immediately to create instances.</em>
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GsonMessageBodyProvider.GsonProviderOptions"})
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
  private static final long OPT_BIT_ALLOW_JACKSON = 0x1L;
  private static final long OPT_BIT_LENIENT = 0x2L;
  private long optBits;

  private @Nullable Gson gson;
  private boolean allowJackson;
  private boolean lenient;
  private ArrayList<MediaType> mediaTypesBuilder = new ArrayList<MediaType>();

  /**
   * Fill builder with attribute values from provided {@link GsonMessageBodyProvider.GsonProviderOptions} instance.
   * Regular attribute values will be replaced with ones of an instance.
   * Instance's absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance instance to copy values from
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder from(GsonMessageBodyProvider.GsonProviderOptions instance) {
    Objects.requireNonNull(instance);
    gson(instance.gson());
    allowJackson(instance.allowJackson());
    lenient(instance.lenient());
    addAllMediaTypes(instance.mediaTypes());
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}.</em>
   * @param gson value for gson
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder gson(Gson gson) {
    this.gson = Objects.requireNonNull(gson);
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}.</em>
   * @param allowJackson value for allowJackson
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
    this.allowJackson = allowJackson;
    optBits |= OPT_BIT_ALLOW_JACKSON;
    return this;
  }

  /**
   * Initializes value for {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}.
   * <p><em>If not set, this attribute will have default value returned by initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}.</em>
   * @param lenient value for lenient
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder lenient(boolean lenient) {
    this.lenient = lenient;
    optBits |= OPT_BIT_LENIENT;
    return this;
  }

  /**
   * Adds one element to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param element mediaTypes element
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
    mediaTypesBuilder.add(Objects.requireNonNull(element));
    return this;
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements array of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType... elements) {
    for (MediaType element : elements) {
      mediaTypesBuilder.add(Objects.requireNonNull(element));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements iterable of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
    mediaTypesBuilder.clear();
    return addAllMediaTypes(elements);
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements iterable of mediaTypes elements
   * @return {@code this} builder for chained invocation
   */
  public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
    for (MediaType element : elements) {
      mediaTypesBuilder.add(Objects.requireNonNull(element));
    }
    return this;
  }
  /**
   * Builds new {@link org.immutables.gson.stream.GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
   * @return immutable instance of GsonProviderOptions
   * @throws exception {@code java.lang.IllegalStateException} if any required attributes are missing
   */
  public GsonMessageBodyProvider.GsonProviderOptions build()
      throws IllegalStateException {
    return GsonProviderOptionsBuilder.ImmutableGsonProviderOptions.validate(new GsonProviderOptionsBuilder.ImmutableGsonProviderOptions(this));
  }

  private boolean allowJacksonIsSet() {
    return (optBits & OPT_BIT_ALLOW_JACKSON) != 0;
  }

  private boolean lenientIsSet() {
    return (optBits & OPT_BIT_LENIENT) != 0;
  }

  /**
   * Immutable implementation of {@link GsonMessageBodyProvider.GsonProviderOptions}.
   * <p>
   * Use builder to create immutable instances:
   * {@code new GsonProviderOptionsBuilder()}.
   * Use static factory method to get default singleton instance:
   * {@code GsonProviderOptionsBuilder.ImmutableGsonProviderOptions.of()}.
   */
  @Immutable
  private static final class ImmutableGsonProviderOptions
      extends GsonMessageBodyProvider.GsonProviderOptions {
    private final Gson gson;
    private final boolean allowJackson;
    private final boolean lenient;
    private final List<MediaType> mediaTypes;

    private ImmutableGsonProviderOptions() {
      this.mediaTypes = Collections.emptyList();
      this.gson = initShim.gson();
      this.allowJackson = initShim.allowJackson();
      this.lenient = initShim.lenient();
      this.initShim = null;
    }

    private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
      this.mediaTypes = createUnmodifiableList(true, builder.mediaTypesBuilder);
      if (builder.gson != null) {
        initShim.gson(builder.gson);
      }
      if (builder.allowJacksonIsSet()) {
        initShim.allowJackson(builder.allowJackson);
      }
      if (builder.lenientIsSet()) {
        initShim.lenient(builder.lenient);
      }
      this.gson = initShim.gson();
      this.allowJackson = initShim.allowJackson();
      this.lenient = initShim.lenient();
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private Gson gson;
      private byte gsonStage;

      Gson gson() {
        if (gsonStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (gsonStage == STAGE_UNINITIALIZED) {
          gsonStage = STAGE_INITIALIZING;
          this.gson = Objects.requireNonNull(ImmutableGsonProviderOptions.super.gson());
          gsonStage = STAGE_INITIALIZED;
        }
        return gson;
      }

      Gson gson(Gson value) {
        this.gson = value;
        gsonStage = STAGE_INITIALIZED;
        return value;
      }
      private boolean allowJackson;
      private byte allowJacksonStage;

      boolean allowJackson() {
        if (allowJacksonStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (allowJacksonStage == STAGE_UNINITIALIZED) {
          allowJacksonStage = STAGE_INITIALIZING;
          this.allowJackson = ImmutableGsonProviderOptions.super.allowJackson();
          allowJacksonStage = STAGE_INITIALIZED;
        }
        return allowJackson;
      }

      boolean allowJackson(boolean value) {
        this.allowJackson = value;
        allowJacksonStage = STAGE_INITIALIZED;
        return value;
      }
      private boolean lenient;
      private byte lenientStage;

      boolean lenient() {
        if (lenientStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (lenientStage == STAGE_UNINITIALIZED) {
          lenientStage = STAGE_INITIALIZING;
          this.lenient = ImmutableGsonProviderOptions.super.lenient();
          lenientStage = STAGE_INITIALIZED;
        }
        return lenient;
      }

      boolean lenient(boolean value) {
        this.lenient = value;
        lenientStage = STAGE_INITIALIZED;
        return value;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = new ArrayList<String>();;
        if (gsonStage == STAGE_INITIALIZING) attributes.add("gson");
        if (allowJacksonStage == STAGE_INITIALIZING) attributes.add("allowJackson");
        if (lenientStage == STAGE_INITIALIZING) attributes.add("lenient");
        return "Cannot build GsonProviderOptions, attribute initializers form cycle" + attributes;
      }
    }


    /**
     * @return value of {@code gson} attribute
     */
    @Override
    public Gson gson() {
      return initShim != null
          ? initShim.gson()
          : gson;
    }

    /**
     * @return value of {@code allowJackson} attribute
     */
    @Override
    public boolean allowJackson() {
      return initShim != null
          ? initShim.allowJackson()
          : allowJackson;
    }

    /**
     * @return value of {@code lenient} attribute
     */
    @Override
    public boolean lenient() {
      return initShim != null
          ? initShim.lenient()
          : lenient;
    }

    /**
     * @return value of {@code mediaTypes} attribute
     */
    @Override
    public List<MediaType> mediaTypes() {
      return mediaTypes;
    }

    /**
     * This instance is equal to instances of {@code ImmutableGsonProviderOptions} with equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableGsonProviderOptions
          && equalTo((ImmutableGsonProviderOptions) another);
    }

    private boolean equalTo(ImmutableGsonProviderOptions another) {
      return gson.equals(another.gson)
          && allowJackson == another.allowJackson
          && lenient == another.lenient
          && mediaTypes.equals(another.mediaTypes);
    }

    /**
     * Computes hash code from attributes: {@code gson}, {@code allowJackson}, {@code lenient}, {@code mediaTypes}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 31;
      h = h * 17 + gson.hashCode();
      h = h * 17 + (allowJackson ? 1231 : 1237);
      h = h * 17 + (lenient ? 1231 : 1237);
      h = h * 17 + mediaTypes.hashCode();
      return h;
    }

    /**
     * Prints immutable value {@code GsonProviderOptions...} with attribute values,
     * excluding any non-generated and auxiliary attributes.
     * @return string representation of value
     */
    @Override
    public String toString() {
      return "GsonProviderOptions{"
          + "gson=" + gson
          + ", allowJackson=" + allowJackson
          + ", lenient=" + lenient
          + ", mediaTypes=" + mediaTypes
          + "}";
    }

    private static final ImmutableGsonProviderOptions INSTANCE = validate(new ImmutableGsonProviderOptions());

    /**
     * Returns default immutable singleton value of {@code GsonProviderOptions}
     * @return immutable instance of GsonProviderOptions
     */
    private static GsonMessageBodyProvider.GsonProviderOptions of() {
      return INSTANCE;
    }

    private static ImmutableGsonProviderOptions validate(ImmutableGsonProviderOptions instance) {
      return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }
  }

  private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
    ArrayList<T> list = iterable instanceof Collection<?>
        ? new ArrayList<T>(((Collection<?>) iterable).size())
        : new ArrayList<T>();

    for (T element : iterable) {
      list.add(Objects.requireNonNull(element, "Null in collection attribute is not allowed"));
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
