/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.immutables.gson.stream.GsonProviderOptionsBuilder;
import org.immutables.gson.stream.JsonGeneratorWriter;
import org.immutables.gson.stream.JsonParserReader;
import org.immutables.value.Value;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class GsonMessageBodyProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private final Gson gson;
    private final Set<MediaType> mediaTypes;
    private final Streamer streamer;

    public GsonMessageBodyProvider() {
        this(new GsonProviderOptionsBuilder().build());
    }

    public GsonMessageBodyProvider(GsonProviderOptions options) {
        this.gson = options.gson();
        this.mediaTypes = GsonMessageBodyProvider.mediaSetFrom(options.mediaTypes());
        this.streamer = GsonMessageBodyProvider.createStreamer(options.allowJackson(), new StreamingOptions(options.gson(), options.lenient()));
    }

    private static Streamer createStreamer(boolean allowJacksonIfAvailable, StreamingOptions options) {
        if (allowJacksonIfAvailable) {
            try {
                return new JacksonStreamer(options);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new GsonStreamer(options);
    }

    private static Set<MediaType> mediaSetFrom(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return Collections.singleton(MediaType.APPLICATION_JSON_TYPE);
        }
        return new HashSet<MediaType>(mediaTypes);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.mediaTypes.contains(mediaType);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.mediaTypes.contains(mediaType);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.streamer.write(this.gson, genericType, t, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.streamer.read(this.gson, genericType, entityStream);
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                String json = this.gson.toJson((Object)new Error(ex.getCause().getMessage()));
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(mediaType).entity((Object)json).build());
            }
            throw ex;
        }
    }

    private static class StreamingOptions {
        final boolean lenient;
        final boolean serializeNulls;
        final boolean htmlSafe;
        final boolean prettyPrinting;

        StreamingOptions(Gson gson, boolean lenient) {
            this.lenient = lenient;
            this.htmlSafe = StreamingOptions.accessField(gson, "htmlSafe", true);
            this.serializeNulls = StreamingOptions.accessField(gson, "serializeNulls", false);
            this.prettyPrinting = StreamingOptions.accessField(gson, "prettyPrinting", false);
        }

        private static boolean accessField(Gson gson, String name, boolean defaultValue) {
            try {
                Field field = Gson.class.getField(name);
                field.setAccessible(true);
                return field.get(gson) == Boolean.TRUE;
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        void setReaderOptions(JsonReader reader) {
            reader.setLenient(this.lenient);
        }

        void setWriterOptions(JsonWriter writer) {
            writer.setSerializeNulls(this.serializeNulls);
            writer.setLenient(this.lenient);
            writer.setHtmlSafe(this.htmlSafe);
            writer.setIndent(this.prettyPrinting ? "  " : "");
        }
    }

    @Value.Immutable(singleton=true)
    @Value.Style(jdkOnly=true, visibility=Value.Style.ImplementationVisibility.PRIVATE)
    public static abstract class GsonProviderOptions {
        @Value.Default
        public Gson gson() {
            GsonBuilder gsonBuilder = new GsonBuilder();
            for (TypeAdapterFactory factory : ServiceLoader.load(TypeAdapterFactory.class)) {
                gsonBuilder.registerTypeAdapterFactory(factory);
            }
            return gsonBuilder.create();
        }

        @Value.Default
        public boolean allowJackson() {
            return true;
        }

        @Value.Default
        public boolean lenient() {
            return false;
        }

        public abstract List<MediaType> mediaTypes();
    }

    private static class JacksonStreamer
    implements Streamer {
        private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        private final StreamingOptions options;

        JacksonStreamer(StreamingOptions options) {
            this.options = options;
        }

        @Override
        public void write(Gson gson, Type type, Object object, OutputStream stream) throws IOException {
            JsonGeneratorWriter writer = null;
            boolean wasOriginalException = false;
            try {
                JsonGenerator generator = JSON_FACTORY.createGenerator(stream);
                if (this.options.prettyPrinting) {
                    generator.useDefaultPrettyPrinter();
                }
                writer = new JsonGeneratorWriter(generator);
                this.options.setWriterOptions(writer);
                gson.getAdapter(TypeToken.get((Type)type)).write((JsonWriter)writer, object);
            }
            catch (IOException ex) {
                wasOriginalException = true;
                throw ex;
            }
            catch (Exception ex) {
                wasOriginalException = true;
                throw new IOException(ex);
            }
            finally {
                block13: {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ex) {
                            if (wasOriginalException) break block13;
                            throw ex;
                        }
                    }
                }
            }
        }

        @Override
        public Object read(Gson gson, Type type, InputStream stream) throws IOException {
            JsonParserReader reader = null;
            try {
                reader = new JsonParserReader(JSON_FACTORY.createParser(stream));
                this.options.setReaderOptions(reader);
                Object object = gson.getAdapter(TypeToken.get((Type)type)).read((JsonReader)reader);
                return object;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class GsonStreamer
    implements Streamer {
        private static final String CHARSET_NAME = "utf-8";
        private final StreamingOptions options;

        GsonStreamer(StreamingOptions options) {
            this.options = options;
        }

        @Override
        public void write(Gson gson, Type type, Object object, OutputStream stream) throws IOException {
            JsonWriter writer = null;
            boolean wasOriginalException = false;
            try {
                writer = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(stream, CHARSET_NAME)));
                this.options.setWriterOptions(writer);
                gson.getAdapter(TypeToken.get((Type)type)).write(writer, object);
            }
            catch (IOException ex) {
                wasOriginalException = true;
                throw ex;
            }
            catch (Exception ex) {
                wasOriginalException = true;
                throw new IOException(ex);
            }
            finally {
                block12: {
                    if (writer != null) {
                        try {
                            writer.flush();
                        }
                        catch (IOException ex) {
                            if (wasOriginalException) break block12;
                            throw ex;
                        }
                    }
                }
            }
        }

        @Override
        public Object read(Gson gson, Type type, InputStream stream) throws IOException {
            JsonReader reader = null;
            try {
                reader = this.createJsonReader(new BufferedReader(new InputStreamReader(stream, CHARSET_NAME)));
                this.options.setReaderOptions(reader);
                return gson.getAdapter(TypeToken.get((Type)type)).read(reader);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }

        private JsonReader createJsonReader(Reader reader) {
            if (!this.options.lenient) {
                return new JsonReader(reader){

                    public String nextString() throws IOException {
                        JsonToken peeked = this.peek();
                        if (peeked == JsonToken.STRING) {
                            return super.nextString();
                        }
                        throw new JsonParseException(String.format("In strict mode (!lenient) string read only from string literal, not %s. Path: %s", peeked, this.getPath()));
                    }
                };
            }
            return new JsonReader(reader);
        }
    }

    private static interface Streamer {
        public void write(Gson var1, Type var2, Object var3, OutputStream var4) throws IOException;

        public Object read(Gson var1, Type var2, InputStream var3) throws IOException;
    }

    static class Error {
        final String error;

        Error(String error) {
            this.error = error;
        }
    }
}

