/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;
import org.immutables.gson.stream.GsonMessageBodyProvider;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
    private static final long OPT_BIT_ALLOW_JACKSON = 1L;
    private static final long OPT_BIT_LENIENT = 2L;
    private long optBits;
    @Nullable
    private Gson gson;
    private boolean allowJackson;
    private boolean lenient;
    private ArrayList<MediaType> mediaTypesBuilder = new ArrayList();

    public final GsonProviderOptionsBuilder from(GsonMessageBodyProvider.GsonProviderOptions instance) {
        Objects.requireNonNull(instance, "instance");
        this.gson(instance.gson());
        this.allowJackson(instance.allowJackson());
        this.lenient(instance.lenient());
        this.addAllMediaTypes(instance.mediaTypes());
        return this;
    }

    public final GsonProviderOptionsBuilder gson(Gson gson) {
        this.gson = Objects.requireNonNull(gson, "gson");
        return this;
    }

    public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
        this.allowJackson = allowJackson;
        this.optBits |= 1L;
        return this;
    }

    public final GsonProviderOptionsBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        this.optBits |= 2L;
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
        this.mediaTypesBuilder.add(Objects.requireNonNull(element, "mediaTypes element"));
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType ... elements) {
        for (MediaType element : elements) {
            this.mediaTypesBuilder.add(Objects.requireNonNull(element, "mediaTypes element"));
        }
        return this;
    }

    public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
        this.mediaTypesBuilder.clear();
        return this.addAllMediaTypes(elements);
    }

    public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
        for (MediaType mediaType : elements) {
            this.mediaTypesBuilder.add(Objects.requireNonNull(mediaType, "mediaTypes element"));
        }
        return this;
    }

    public GsonMessageBodyProvider.GsonProviderOptions build() throws IllegalStateException {
        return ImmutableGsonProviderOptions.validate(new ImmutableGsonProviderOptions(this));
    }

    private boolean allowJacksonIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean lenientIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Immutable
    private static final class ImmutableGsonProviderOptions
    extends GsonMessageBodyProvider.GsonProviderOptions {
        private final Gson gson;
        private final boolean allowJackson;
        private final boolean lenient;
        private final List<MediaType> mediaTypes;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile InitShim initShim = new InitShim();
        private static final ImmutableGsonProviderOptions INSTANCE = ImmutableGsonProviderOptions.validate(new ImmutableGsonProviderOptions());

        private ImmutableGsonProviderOptions() {
            this.mediaTypes = Collections.emptyList();
            this.gson = this.initShim.gson();
            this.allowJackson = this.initShim.allowJackson();
            this.lenient = this.initShim.lenient();
            this.initShim = null;
        }

        private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
            this.mediaTypes = GsonProviderOptionsBuilder.createUnmodifiableList(true, builder.mediaTypesBuilder);
            if (builder.gson != null) {
                this.initShim.gson(builder.gson);
            }
            if (builder.allowJacksonIsSet()) {
                this.initShim.allowJackson(builder.allowJackson);
            }
            if (builder.lenientIsSet()) {
                this.initShim.lenient(builder.lenient);
            }
            this.gson = this.initShim.gson();
            this.allowJackson = this.initShim.allowJackson();
            this.lenient = this.initShim.lenient();
            this.initShim = null;
        }

        @Override
        public Gson gson() {
            return this.initShim != null ? this.initShim.gson() : this.gson;
        }

        @Override
        public boolean allowJackson() {
            return this.initShim != null ? this.initShim.allowJackson() : this.allowJackson;
        }

        @Override
        public boolean lenient() {
            return this.initShim != null ? this.initShim.lenient() : this.lenient;
        }

        @Override
        public List<MediaType> mediaTypes() {
            return this.mediaTypes;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableGsonProviderOptions && this.equalTo((ImmutableGsonProviderOptions)another);
        }

        private boolean equalTo(ImmutableGsonProviderOptions another) {
            return this.gson.equals(another.gson) && this.allowJackson == another.allowJackson && this.lenient == another.lenient && this.mediaTypes.equals(another.mediaTypes);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.gson.hashCode();
            h = h * 17 + (this.allowJackson ? 1231 : 1237);
            h = h * 17 + (this.lenient ? 1231 : 1237);
            h = h * 17 + this.mediaTypes.hashCode();
            return h;
        }

        public String toString() {
            return "GsonProviderOptions{gson=" + this.gson + ", allowJackson=" + this.allowJackson + ", lenient=" + this.lenient + ", mediaTypes=" + this.mediaTypes + "}";
        }

        private static GsonMessageBodyProvider.GsonProviderOptions of() {
            return INSTANCE;
        }

        private static ImmutableGsonProviderOptions validate(ImmutableGsonProviderOptions instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        private final class InitShim {
            private Gson gson;
            private byte gsonStage;
            private boolean allowJackson;
            private byte allowJacksonStage;
            private boolean lenient;
            private byte lenientStage;

            private InitShim() {
            }

            Gson gson() {
                if (this.gsonStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.gsonStage == 0) {
                    this.gsonStage = (byte)-1;
                    this.gson = Objects.requireNonNull(ImmutableGsonProviderOptions.super.gson(), "gson");
                    this.gsonStage = 1;
                }
                return this.gson;
            }

            Gson gson(Gson value) {
                this.gson = value;
                this.gsonStage = 1;
                return value;
            }

            boolean allowJackson() {
                if (this.allowJacksonStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.allowJacksonStage == 0) {
                    this.allowJacksonStage = (byte)-1;
                    this.allowJackson = ImmutableGsonProviderOptions.super.allowJackson();
                    this.allowJacksonStage = 1;
                }
                return this.allowJackson;
            }

            boolean allowJackson(boolean value) {
                this.allowJackson = value;
                this.allowJacksonStage = 1;
                return value;
            }

            boolean lenient() {
                if (this.lenientStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.lenientStage == 0) {
                    this.lenientStage = (byte)-1;
                    this.lenient = ImmutableGsonProviderOptions.super.lenient();
                    this.lenientStage = 1;
                }
                return this.lenient;
            }

            boolean lenient(boolean value) {
                this.lenient = value;
                this.lenientStage = 1;
                return value;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.gsonStage == -1) {
                    attributes.add("gson");
                }
                if (this.allowJacksonStage == -1) {
                    attributes.add("allowJackson");
                }
                if (this.lenientStage == -1) {
                    attributes.add("lenient");
                }
                return "Cannot build GsonProviderOptions, attribute initializers form cycle" + attributes;
            }
        }
    }
}

