/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;
import org.immutables.gson.stream.GsonMessageBodyProvider;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GsonMessageBodyProvider.GsonProviderOptions", generator="Immutables")
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
    private static final long OPT_BIT_ALLOW_JACKSON = 1L;
    private static final long OPT_BIT_LENIENT = 2L;
    private long optBits;
    @Nullable
    private Gson gson;
    private boolean allowJackson;
    private boolean lenient;
    @Nullable
    private GsonMessageBodyProvider.ExceptionHandler exceptionHandler;
    private List<MediaType> mediaTypes = new ArrayList<MediaType>();

    public final GsonProviderOptionsBuilder from(GsonMessageBodyProvider.GsonProviderOptions instance) {
        Objects.requireNonNull(instance, "instance");
        this.gson(instance.gson());
        this.allowJackson(instance.allowJackson());
        this.lenient(instance.lenient());
        this.exceptionHandler(instance.exceptionHandler());
        this.addAllMediaTypes(instance.mediaTypes());
        return this;
    }

    public final GsonProviderOptionsBuilder gson(Gson gson) {
        this.gson = Objects.requireNonNull(gson, "gson");
        return this;
    }

    public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
        this.allowJackson = allowJackson;
        this.optBits |= 1L;
        return this;
    }

    public final GsonProviderOptionsBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        this.optBits |= 2L;
        return this;
    }

    public final GsonProviderOptionsBuilder exceptionHandler(GsonMessageBodyProvider.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
        this.mediaTypes.add(Objects.requireNonNull(element, "mediaTypes element"));
        return this;
    }

    public final GsonProviderOptionsBuilder addMediaTypes(MediaType ... elements) {
        MediaType[] mediaTypeArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            MediaType element = mediaTypeArray[n2];
            this.mediaTypes.add(Objects.requireNonNull(element, "mediaTypes element"));
            ++n2;
        }
        return this;
    }

    public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
        this.mediaTypes.clear();
        return this.addAllMediaTypes(elements);
    }

    public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
        for (MediaType mediaType : elements) {
            this.mediaTypes.add(Objects.requireNonNull(mediaType, "mediaTypes element"));
        }
        return this;
    }

    public GsonMessageBodyProvider.GsonProviderOptions build() {
        return new ImmutableGsonProviderOptions(this);
    }

    private boolean allowJacksonIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean lenientIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GsonMessageBodyProvider.GsonProviderOptions", generator="Immutables")
    @Immutable
    private static final class ImmutableGsonProviderOptions
    extends GsonMessageBodyProvider.GsonProviderOptions {
        private final Gson gson;
        private final boolean allowJackson;
        private final boolean lenient;
        private final GsonMessageBodyProvider.ExceptionHandler exceptionHandler;
        private final List<MediaType> mediaTypes;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
            this.mediaTypes = GsonProviderOptionsBuilder.createUnmodifiableList(true, builder.mediaTypes);
            if (builder.gson != null) {
                this.initShim.gson(builder.gson);
            }
            if (builder.allowJacksonIsSet()) {
                this.initShim.allowJackson(builder.allowJackson);
            }
            if (builder.lenientIsSet()) {
                this.initShim.lenient(builder.lenient);
            }
            if (builder.exceptionHandler != null) {
                this.initShim.exceptionHandler(builder.exceptionHandler);
            }
            this.gson = this.initShim.gson();
            this.allowJackson = this.initShim.allowJackson();
            this.lenient = this.initShim.lenient();
            this.exceptionHandler = this.initShim.exceptionHandler();
            this.initShim = null;
        }

        @Override
        public Gson gson() {
            InitShim shim = this.initShim;
            return shim != null ? shim.gson() : this.gson;
        }

        @Override
        public boolean allowJackson() {
            InitShim shim = this.initShim;
            return shim != null ? shim.allowJackson() : this.allowJackson;
        }

        @Override
        public boolean lenient() {
            InitShim shim = this.initShim;
            return shim != null ? shim.lenient() : this.lenient;
        }

        @Override
        public GsonMessageBodyProvider.ExceptionHandler exceptionHandler() {
            InitShim shim = this.initShim;
            return shim != null ? shim.exceptionHandler() : this.exceptionHandler;
        }

        @Override
        public List<MediaType> mediaTypes() {
            return this.mediaTypes;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableGsonProviderOptions && this.equalTo((ImmutableGsonProviderOptions)another);
        }

        private boolean equalTo(ImmutableGsonProviderOptions another) {
            return this.gson.equals(another.gson) && this.allowJackson == another.allowJackson && this.lenient == another.lenient && this.exceptionHandler.equals(another.exceptionHandler) && this.mediaTypes.equals(another.mediaTypes);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.gson.hashCode();
            h += (h << 5) + (this.allowJackson ? 1231 : 1237);
            h += (h << 5) + (this.lenient ? 1231 : 1237);
            h += (h << 5) + this.exceptionHandler.hashCode();
            h += (h << 5) + this.mediaTypes.hashCode();
            return h;
        }

        public String toString() {
            return "GsonProviderOptions{gson=" + this.gson + ", allowJackson=" + this.allowJackson + ", lenient=" + this.lenient + ", exceptionHandler=" + this.exceptionHandler + ", mediaTypes=" + this.mediaTypes + "}";
        }

        @Generated(from="GsonMessageBodyProvider.GsonProviderOptions", generator="Immutables")
        private final class InitShim {
            private byte gsonBuildStage = 0;
            private Gson gson;
            private byte allowJacksonBuildStage = 0;
            private boolean allowJackson;
            private byte lenientBuildStage = 0;
            private boolean lenient;
            private byte exceptionHandlerBuildStage = 0;
            private GsonMessageBodyProvider.ExceptionHandler exceptionHandler;

            private InitShim() {
            }

            Gson gson() {
                if (this.gsonBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.gsonBuildStage == 0) {
                    this.gsonBuildStage = (byte)-1;
                    this.gson = Objects.requireNonNull(ImmutableGsonProviderOptions.super.gson(), "gson");
                    this.gsonBuildStage = 1;
                }
                return this.gson;
            }

            void gson(Gson gson) {
                this.gson = gson;
                this.gsonBuildStage = 1;
            }

            boolean allowJackson() {
                if (this.allowJacksonBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.allowJacksonBuildStage == 0) {
                    this.allowJacksonBuildStage = (byte)-1;
                    this.allowJackson = ImmutableGsonProviderOptions.super.allowJackson();
                    this.allowJacksonBuildStage = 1;
                }
                return this.allowJackson;
            }

            void allowJackson(boolean allowJackson) {
                this.allowJackson = allowJackson;
                this.allowJacksonBuildStage = 1;
            }

            boolean lenient() {
                if (this.lenientBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.lenientBuildStage == 0) {
                    this.lenientBuildStage = (byte)-1;
                    this.lenient = ImmutableGsonProviderOptions.super.lenient();
                    this.lenientBuildStage = 1;
                }
                return this.lenient;
            }

            void lenient(boolean lenient) {
                this.lenient = lenient;
                this.lenientBuildStage = 1;
            }

            GsonMessageBodyProvider.ExceptionHandler exceptionHandler() {
                if (this.exceptionHandlerBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.exceptionHandlerBuildStage == 0) {
                    this.exceptionHandlerBuildStage = (byte)-1;
                    this.exceptionHandler = Objects.requireNonNull(ImmutableGsonProviderOptions.super.exceptionHandler(), "exceptionHandler");
                    this.exceptionHandlerBuildStage = 1;
                }
                return this.exceptionHandler;
            }

            void exceptionHandler(GsonMessageBodyProvider.ExceptionHandler exceptionHandler) {
                this.exceptionHandler = exceptionHandler;
                this.exceptionHandlerBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.gsonBuildStage == -1) {
                    attributes.add("gson");
                }
                if (this.allowJacksonBuildStage == -1) {
                    attributes.add("allowJackson");
                }
                if (this.lenientBuildStage == -1) {
                    attributes.add("lenient");
                }
                if (this.exceptionHandlerBuildStage == -1) {
                    attributes.add("exceptionHandler");
                }
                return "Cannot build GsonProviderOptions, attribute initializers form cycle " + attributes;
            }
        }
    }
}

