package org.immutables.gson.stream;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.ws.rs.core.MediaType;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code GsonProviderOptionsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "GsonMessageBodyProvider.GsonProviderOptions", generator = "Immutables")
@SuppressWarnings({"resource", "unused", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class GsonProviderOptionsBuilder {
  private static final long OPT_BIT_ALLOW_JACKSON = 0x1L;
  private static final long OPT_BIT_LENIENT = 0x2L;
  private long optBits;

  private @Nullable Gson gson;
  private boolean allowJackson;
  private boolean lenient;
  private @Nullable GsonMessageBodyProvider.ExceptionHandler exceptionHandler;
  private List<MediaType> mediaTypes = new ArrayList<MediaType>();

  /**
   * Creates a builder for {@link GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions} instances.
   * <pre>
   * new GsonProviderOptionsBuilder()
   *    .gson(com.google.gson.Gson) // optional {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}
   *    .allowJackson(boolean) // optional {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}
   *    .lenient(boolean) // optional {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}
   *    .exceptionHandler(org.immutables.gson.stream.GsonMessageBodyProvider.ExceptionHandler) // optional {@link GsonMessageBodyProvider.GsonProviderOptions#exceptionHandler() exceptionHandler}
   *    .addMediaTypes|addAllMediaTypes(javax.ws.rs.core.MediaType) // {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} elements
   *    .build();
   * </pre>
   */
  public GsonProviderOptionsBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code GsonProviderOptions} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder from(GsonMessageBodyProvider.GsonProviderOptions instance) {
    Objects.requireNonNull(instance, "instance");
    gson(instance.gson());
    allowJackson(instance.allowJackson());
    lenient(instance.lenient());
    exceptionHandler(instance.exceptionHandler());
    addAllMediaTypes(instance.mediaTypes());
    return this;
  }

  /**
   * Initializes the value for the {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#gson() gson}.</em>
   * @param gson The value for gson 
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder gson(Gson gson) {
    this.gson = Objects.requireNonNull(gson, "gson");
    return this;
  }

  /**
   * Initializes the value for the {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#allowJackson() allowJackson}.</em>
   * @param allowJackson The value for allowJackson 
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder allowJackson(boolean allowJackson) {
    this.allowJackson = allowJackson;
    optBits |= OPT_BIT_ALLOW_JACKSON;
    return this;
  }

  /**
   * Initializes the value for the {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#lenient() lenient}.</em>
   * @param lenient The value for lenient 
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder lenient(boolean lenient) {
    this.lenient = lenient;
    optBits |= OPT_BIT_LENIENT;
    return this;
  }

  /**
   * Initializes the value for the {@link GsonMessageBodyProvider.GsonProviderOptions#exceptionHandler() exceptionHandler} attribute.
   * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GsonMessageBodyProvider.GsonProviderOptions#exceptionHandler() exceptionHandler}.</em>
   * @param exceptionHandler The value for exceptionHandler 
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder exceptionHandler(GsonMessageBodyProvider.ExceptionHandler exceptionHandler) {
    this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler");
    return this;
  }

  /**
   * Adds one element to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param element A mediaTypes element
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType element) {
    this.mediaTypes.add(Objects.requireNonNull(element, "mediaTypes element"));
    return this;
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements An array of mediaTypes elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder addMediaTypes(MediaType... elements) {
    for (MediaType element : elements) {
      this.mediaTypes.add(Objects.requireNonNull(element, "mediaTypes element"));
    }
    return this;
  }


  /**
   * Sets or replaces all elements for {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements An iterable of mediaTypes elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder mediaTypes(Iterable<? extends MediaType> elements) {
    this.mediaTypes.clear();
    return addAllMediaTypes(elements);
  }

  /**
   * Adds elements to {@link GsonMessageBodyProvider.GsonProviderOptions#mediaTypes() mediaTypes} list.
   * @param elements An iterable of mediaTypes elements
   * @return {@code this} builder for use in a chained invocation
   */
  public final GsonProviderOptionsBuilder addAllMediaTypes(Iterable<? extends MediaType> elements) {
    for (MediaType element : elements) {
      this.mediaTypes.add(Objects.requireNonNull(element, "mediaTypes element"));
    }
    return this;
  }

  /**
   * Builds a new {@link GsonMessageBodyProvider.GsonProviderOptions GsonProviderOptions}.
   * @return An immutable instance of GsonProviderOptions
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public GsonMessageBodyProvider.GsonProviderOptions build() {
    return new GsonProviderOptionsBuilder.ImmutableGsonProviderOptions(this);
  }

  private boolean allowJacksonIsSet() {
    return (optBits & OPT_BIT_ALLOW_JACKSON) != 0;
  }

  private boolean lenientIsSet() {
    return (optBits & OPT_BIT_LENIENT) != 0;
  }

  /**
   * Immutable implementation of {@link GsonMessageBodyProvider.GsonProviderOptions}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new GsonProviderOptionsBuilder()}.
   */
  @Generated(from = "GsonMessageBodyProvider.GsonProviderOptions", generator = "Immutables")
  @Immutable
  private static final class ImmutableGsonProviderOptions
      extends GsonMessageBodyProvider.GsonProviderOptions {
    private final Gson gson;
    private final boolean allowJackson;
    private final boolean lenient;
    private final GsonMessageBodyProvider.ExceptionHandler exceptionHandler;
    private final List<MediaType> mediaTypes;

    private ImmutableGsonProviderOptions(GsonProviderOptionsBuilder builder) {
      this.mediaTypes = createUnmodifiableList(true, builder.mediaTypes);
      if (builder.gson != null) {
        initShim.gson(builder.gson);
      }
      if (builder.allowJacksonIsSet()) {
        initShim.allowJackson(builder.allowJackson);
      }
      if (builder.lenientIsSet()) {
        initShim.lenient(builder.lenient);
      }
      if (builder.exceptionHandler != null) {
        initShim.exceptionHandler(builder.exceptionHandler);
      }
      this.gson = initShim.gson();
      this.allowJackson = initShim.allowJackson();
      this.lenient = initShim.lenient();
      this.exceptionHandler = initShim.exceptionHandler();
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "GsonMessageBodyProvider.GsonProviderOptions", generator = "Immutables")
    private final class InitShim {
      private byte gsonBuildStage = STAGE_UNINITIALIZED;
      private Gson gson;

      Gson gson() {
        if (gsonBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (gsonBuildStage == STAGE_UNINITIALIZED) {
          gsonBuildStage = STAGE_INITIALIZING;
          this.gson = Objects.requireNonNull(ImmutableGsonProviderOptions.super.gson(), "gson");
          gsonBuildStage = STAGE_INITIALIZED;
        }
        return this.gson;
      }

      void gson(Gson gson) {
        this.gson = gson;
        gsonBuildStage = STAGE_INITIALIZED;
      }

      private byte allowJacksonBuildStage = STAGE_UNINITIALIZED;
      private boolean allowJackson;

      boolean allowJackson() {
        if (allowJacksonBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (allowJacksonBuildStage == STAGE_UNINITIALIZED) {
          allowJacksonBuildStage = STAGE_INITIALIZING;
          this.allowJackson = ImmutableGsonProviderOptions.super.allowJackson();
          allowJacksonBuildStage = STAGE_INITIALIZED;
        }
        return this.allowJackson;
      }

      void allowJackson(boolean allowJackson) {
        this.allowJackson = allowJackson;
        allowJacksonBuildStage = STAGE_INITIALIZED;
      }

      private byte lenientBuildStage = STAGE_UNINITIALIZED;
      private boolean lenient;

      boolean lenient() {
        if (lenientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (lenientBuildStage == STAGE_UNINITIALIZED) {
          lenientBuildStage = STAGE_INITIALIZING;
          this.lenient = ImmutableGsonProviderOptions.super.lenient();
          lenientBuildStage = STAGE_INITIALIZED;
        }
        return this.lenient;
      }

      void lenient(boolean lenient) {
        this.lenient = lenient;
        lenientBuildStage = STAGE_INITIALIZED;
      }

      private byte exceptionHandlerBuildStage = STAGE_UNINITIALIZED;
      private GsonMessageBodyProvider.ExceptionHandler exceptionHandler;

      GsonMessageBodyProvider.ExceptionHandler exceptionHandler() {
        if (exceptionHandlerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (exceptionHandlerBuildStage == STAGE_UNINITIALIZED) {
          exceptionHandlerBuildStage = STAGE_INITIALIZING;
          this.exceptionHandler = Objects.requireNonNull(ImmutableGsonProviderOptions.super.exceptionHandler(), "exceptionHandler");
          exceptionHandlerBuildStage = STAGE_INITIALIZED;
        }
        return this.exceptionHandler;
      }

      void exceptionHandler(GsonMessageBodyProvider.ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        exceptionHandlerBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (gsonBuildStage == STAGE_INITIALIZING) attributes.add("gson");
        if (allowJacksonBuildStage == STAGE_INITIALIZING) attributes.add("allowJackson");
        if (lenientBuildStage == STAGE_INITIALIZING) attributes.add("lenient");
        if (exceptionHandlerBuildStage == STAGE_INITIALIZING) attributes.add("exceptionHandler");
        return "Cannot build GsonProviderOptions, attribute initializers form cycle " + attributes;
      }
    }

    /**
     * @return The value of the {@code gson} attribute
     */
    @Override
    public Gson gson() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.gson()
          : this.gson;
    }

    /**
     * @return The value of the {@code allowJackson} attribute
     */
    @Override
    public boolean allowJackson() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.allowJackson()
          : this.allowJackson;
    }

    /**
     * @return The value of the {@code lenient} attribute
     */
    @Override
    public boolean lenient() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.lenient()
          : this.lenient;
    }

    /**
     * @return The value of the {@code exceptionHandler} attribute
     */
    @Override
    public GsonMessageBodyProvider.ExceptionHandler exceptionHandler() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.exceptionHandler()
          : this.exceptionHandler;
    }

    /**
     * @return The value of the {@code mediaTypes} attribute
     */
    @Override
    public List<MediaType> mediaTypes() {
      return mediaTypes;
    }

    /**
     * This instance is equal to all instances of {@code ImmutableGsonProviderOptions} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof GsonProviderOptionsBuilder.ImmutableGsonProviderOptions
          && equalTo(0, (GsonProviderOptionsBuilder.ImmutableGsonProviderOptions) another);
    }

    private boolean equalTo(int synthetic, GsonProviderOptionsBuilder.ImmutableGsonProviderOptions another) {
      return gson.equals(another.gson)
          && allowJackson == another.allowJackson
          && lenient == another.lenient
          && exceptionHandler.equals(another.exceptionHandler)
          && mediaTypes.equals(another.mediaTypes);
    }

    /**
     * Computes a hash code from attributes: {@code gson}, {@code allowJackson}, {@code lenient}, {@code exceptionHandler}, {@code mediaTypes}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + gson.hashCode();
      h += (h << 5) + (allowJackson ? 1231 : 1237);
      h += (h << 5) + (lenient ? 1231 : 1237);
      h += (h << 5) + exceptionHandler.hashCode();
      h += (h << 5) + mediaTypes.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code GsonProviderOptions} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "GsonProviderOptions{"
          + "gson=" + gson
          + ", allowJackson=" + allowJackson
          + ", lenient=" + lenient
          + ", exceptionHandler=" + exceptionHandler
          + ", mediaTypes=" + mediaTypes
          + "}";
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
