/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.metainf.processor;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.immutables.generator.AbstractTemplate;
import org.immutables.generator.AnnotationMirrors;
import org.immutables.generator.Generator;
import org.immutables.generator.TypeHierarchyCollector;
import org.immutables.metainf.Metainf;

@Generator.Template
class Metaservices
extends AbstractTemplate {
    Metaservices() {
    }

    ListMultimap<String, String> allMetaservices() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Element element : this.round().getElementsAnnotatedWith(Metainf.Service.class)) {
            TypeElement typeElement = this.validated(element);
            if (typeElement == null) continue;
            Set<String> interfaceNames = this.extractServiceInterfaceNames(typeElement);
            String binaryName = this.processing().getElementUtils().getBinaryName(typeElement).toString();
            builder.putAll((Object)binaryName, interfaceNames);
        }
        return builder.build();
    }

    private Set<String> extractServiceInterfaceNames(TypeElement typeElement) {
        ImmutableList typesMirrors = AnnotationMirrors.getTypesFromMirrors((String)Metainf.Service.class.getCanonicalName(), (String)"value", typeElement.getAnnotationMirrors());
        if (typesMirrors.isEmpty()) {
            return this.useIntrospectedInterfacesForServices(typeElement);
        }
        return this.useProvidedTypesForServices(typeElement, (ImmutableList<TypeMirror>)typesMirrors);
    }

    private Set<String> useIntrospectedInterfacesForServices(TypeElement typeElement) {
        TypeHierarchyCollector typeHierarchyCollector = new TypeHierarchyCollector();
        typeHierarchyCollector.collectFrom(typeElement.asType());
        return typeHierarchyCollector.implementedInterfaceNames();
    }

    private Set<String> useProvidedTypesForServices(TypeElement typeElement, ImmutableList<TypeMirror> typesMirrors) {
        ArrayList wrongTypes = Lists.newArrayList();
        ArrayList types = Lists.newArrayList();
        for (TypeMirror typeMirror : typesMirrors) {
            if (typeMirror.getKind() != TypeKind.DECLARED || !this.processing().getTypeUtils().isAssignable(typeElement.asType(), typeMirror)) {
                wrongTypes.add(typeMirror.toString());
                continue;
            }
            types.add(typeMirror.toString());
        }
        if (!wrongTypes.isEmpty()) {
            this.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, "@Metainf.Service(value = {...}) contains types that are not implemented by " + typeElement.getSimpleName() + ": " + wrongTypes, typeElement, AnnotationMirrors.findAnnotation(typeElement.getAnnotationMirrors(), Metainf.Service.class));
        }
        return FluentIterable.from((Iterable)types).toSet();
    }

    @Nullable
    private TypeElement validated(Element element) {
        Element enclosingElement = element.getEnclosingElement();
        if (element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.PUBLIC) && enclosingElement != null) {
            if (enclosingElement.getKind() == ElementKind.PACKAGE && !element.getModifiers().contains((Object)Modifier.ABSTRACT) && !((PackageElement)enclosingElement).isUnnamed()) {
                return (TypeElement)element;
            }
            if (enclosingElement.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.STATIC)) {
                return (TypeElement)element;
            }
        }
        this.processing().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element annotated with @Metainf.Service annotation should be public top-level non-abstract or static class in a package", element);
        return null;
    }
}

