/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.metainf.internal.$generator$;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.immutables.extgenerator.GeneratedImportsModifier;
import org.immutables.metainf.internal.;
import org.immutables.metainf.internal.$guava$.base.$Function;
import org.immutables.metainf.internal.$guava$.base.$Joiner;
import org.immutables.metainf.internal.$guava$.collect.$HashMultimap;
import org.immutables.metainf.internal.$guava$.collect.$ImmutableList;
import org.immutables.metainf.internal.$guava$.collect.$Iterables;
import org.immutables.metainf.internal.$guava$.collect.$Lists;
import org.immutables.metainf.internal.$guava$.collect.$Maps;
import org.immutables.metainf.internal.$guava$.collect.$Multimap;
import org.immutables.metainf.internal.$guava$.collect.$Ordering;
import org.immutables.metainf.internal.$guava$.collect.$Sets;

final class $PostprocessingMachine {
    private static final char ASCII_MAX = '\u007f';
    private static final $Joiner JOINER = $Joiner.on("");
    private static final $ImmutableList<GeneratedImportsModifier> importsModifiers = $ImmutableList.copyOf(ServiceLoader.load(GeneratedImportsModifier.class, $PostprocessingMachine.class.getClassLoader()));

    private $PostprocessingMachine() {
    }

    static CharSequence rewrite(CharSequence content) {
        try {
            return $PostprocessingMachine.rewrite(content, new ImportsBuilder(), ScanAtMost.ALL);
        }
        catch (UnsupportedEncodingException ex) {
            return content;
        }
    }

    static CharSequence collectHeader(CharSequence content) {
        try {
            return $PostprocessingMachine.rewrite(content, new ImportsBuilder(), ScanAtMost.HEADER);
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    static .generator..SourceExtraction.Imports collectImports(CharSequence content) {
        try {
            ImportsBuilder importsBuilder = new ImportsBuilder();
            $PostprocessingMachine.rewrite(content, importsBuilder, ScanAtMost.IMPORTS);
            return .generator..SourceExtraction.Imports.of(importsBuilder.imports, importsBuilder.originalImports);
        }
        catch (UnsupportedEncodingException ex) {
            return .generator..SourceExtraction.Imports.empty();
        }
    }

    private static CharSequence rewrite(CharSequence content, ImportsBuilder importsBuilder, ScanAtMost scanAtMost) throws UnsupportedEncodingException {
        String currentPackage = "";
        State state = State.UNDEFINED;
        int packageFrom = -1;
        int importFrom = -1;
        int nextPartFrom = 0;
        boolean importStarts = false;
        int classNameOccurrencesInImportBlock = 0;
        int classNameFrom = -1;
        int classNameTo = -1;
        FiniteStateMachine machine = new FiniteStateMachine();
        QualifiedNameMachine qualifiedNameMachine = new QualifiedNameMachine();
        QualifiedNameMachine importsQualifiedNameMachine = new QualifiedNameMachine().allowNestedTypes();
        CommentMachine commentMachine = new CommentMachine();
        ClassNameMachine nameMachine = new ClassNameMachine();
        CharSequence header = null;
        block7: for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\r') continue;
            commentMachine.nextChar(c);
            if (commentMachine.isInComment()) continue;
            if (c > '\u007f') {
                throw new UnsupportedEncodingException();
            }
            if (header == null && state.pastHeader()) {
                int lastLineIndex = i;
                while (--lastLineIndex > 0 && content.charAt(lastLineIndex) != '\n') {
                }
                header = content.subSequence(0, Math.max(0, lastLineIndex));
                if (scanAtMost == ScanAtMost.HEADER) {
                    return header;
                }
            }
            if (scanAtMost == ScanAtMost.IMPORTS && state.atClassDefinition()) {
                return "";
            }
            switch (state) {
                case UNDEFINED: {
                    state = machine.nextChar(c).or(state);
                    continue block7;
                }
                case PACKAGE: {
                    if (c == ' ') {
                        packageFrom = i + 1;
                    }
                    if (c != ';') continue block7;
                    nextPartFrom = i + 2;
                    currentPackage = content.subSequence(packageFrom, i).toString();
                    importsBuilder.setCurrentPackage(currentPackage);
                    state = State.UNDEFINED;
                    packageFrom = -1;
                    continue block7;
                }
                case IMPORTS: {
                    nameMachine.nextChar(c, i, true);
                    if (!importsQualifiedNameMachine.isFinished()) {
                        importsQualifiedNameMachine.nextChar(c, i);
                    }
                    if (nameMachine.isFound()) {
                        ++classNameOccurrencesInImportBlock;
                        classNameFrom = nameMachine.classNameFrom;
                        classNameTo = nameMachine.classNameTo;
                    }
                    if (!importStarts && c == ' ') {
                        importFrom = i + 1;
                        importStarts = true;
                    }
                    if (c != ';') continue block7;
                    nextPartFrom = i + 2;
                    if (importsQualifiedNameMachine.isFinished()) {
                        String simpleName = content.subSequence(importsQualifiedNameMachine.packageTo, importsQualifiedNameMachine.importTo).toString();
                        String qualifiedName = content.subSequence(importsQualifiedNameMachine.importFrom, importsQualifiedNameMachine.importTo).toString();
                        String packageFromImport = content.subSequence(importFrom, i).toString();
                        importsBuilder.addOriginalImport(simpleName, qualifiedName, packageFromImport);
                    } else {
                        importsBuilder.addImport(content.subSequence(importFrom, i).toString());
                    }
                    importsQualifiedNameMachine.reset();
                    state = State.UNDEFINED;
                    importFrom = -1;
                    importStarts = false;
                    if (classNameOccurrencesInImportBlock != 1) continue block7;
                    importsBuilder.addToStopList(content.subSequence(classNameFrom, classNameTo).toString());
                    nameMachine.reset();
                    classNameOccurrencesInImportBlock = 0;
                    continue block7;
                }
                case ANNOTATION: {
                    c = content.charAt(--i);
                    state = State.CLASS;
                }
                case CLASS: {
                    nameMachine.nextChar(c, i);
                    qualifiedNameMachine.nextChar(c, i);
                    if (qualifiedNameMachine.isFinished()) {
                        importsBuilder.addImportCandidate(content.subSequence(qualifiedNameMachine.packageTo, qualifiedNameMachine.importTo).toString(), content.subSequence(qualifiedNameMachine.importFrom, qualifiedNameMachine.importTo).toString(), qualifiedNameMachine.importFrom, qualifiedNameMachine.importTo, qualifiedNameMachine.packageTo);
                        qualifiedNameMachine.reset();
                    }
                    if (qualifiedNameMachine.state == FullyQualifiedNameState.CLASS) {
                        nameMachine.reset();
                    }
                    if (!nameMachine.isFound()) continue block7;
                    importsBuilder.addException(content.subSequence(nameMachine.classNameFrom, nameMachine.classNameTo).toString());
                }
            }
        }
        importsBuilder.preBuild();
        List<ImportCandidate> candidates = importsBuilder.candidates();
        ArrayList<CharSequence> contentParts = $Lists.newArrayListWithExpectedSize(candidates.size());
        for (ImportCandidate importCandidate : candidates) {
            if (importCandidate.importTo != -1) {
                importsBuilder.addImport(importCandidate.preparedImport);
            }
            contentParts.add(content.subSequence(nextPartFrom, importCandidate.importFrom));
            nextPartFrom = importCandidate.packageTo;
        }
        String imports = importsBuilder.build();
        contentParts.add(content.subSequence(nextPartFrom, content.length()));
        ArrayList<CharSequence> headerParts = $Lists.newArrayListWithExpectedSize(8);
        if (header != null) {
            headerParts.add(header);
            if (header.length() > 0) {
                headerParts.add("\n");
            }
        }
        if (!currentPackage.isEmpty()) {
            headerParts.add("package ");
            headerParts.add(currentPackage);
            headerParts.add(";\n\n");
        }
        headerParts.add(imports);
        return JOINER.join($Iterables.concat(headerParts, contentParts));
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabetic(char c) {
        return $PostprocessingMachine.isLowerCaseAlphabetic(c) || $PostprocessingMachine.isUpperCaseAlphabetic(c);
    }

    private static boolean isLowerCaseAlphabetic(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCaseAlphabetic(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isUnderscore(char c) {
        return c == '_';
    }

    private static final class ImportCandidate
    implements Comparable<ImportCandidate> {
        final int importFrom;
        final int importTo;
        final int packageTo;
        String preparedImport;
        String simpleName;

        private ImportCandidate(int importFrom, int importTo, int packageTo, String preparedImport, String simpleName) {
            this.importFrom = importFrom;
            this.importTo = importTo;
            this.packageTo = packageTo;
            this.preparedImport = preparedImport;
            this.simpleName = simpleName;
        }

        @Override
        public int compareTo(ImportCandidate other) {
            return this.importFrom - other.importFrom;
        }
    }

    static enum ClassNameState {
        UNDEFINED,
        IDLE,
        CLASS_NAME;

    }

    static final class ClassNameMachine {
        ClassNameState state = ClassNameState.UNDEFINED;
        int classNameFrom = -1;
        int classNameTo = -1;

        ClassNameMachine() {
        }

        boolean isFound() {
            return this.classNameFrom != -1 && this.classNameTo != -1;
        }

        void reset() {
            this.state = ClassNameState.UNDEFINED;
            this.classNameFrom = -1;
            this.classNameTo = -1;
        }

        void nextChar(char c, int i) {
            this.nextChar(c, i, false);
        }

        void nextChar(char c, int i, boolean noIdle) {
            switch (this.state) {
                case UNDEFINED: {
                    if ($PostprocessingMachine.isUpperCaseAlphabetic(c)) {
                        this.state = ClassNameState.CLASS_NAME;
                        this.classNameFrom = i;
                        this.classNameTo = -1;
                        break;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c)) {
                        if (noIdle) break;
                        this.state = ClassNameState.IDLE;
                        break;
                    }
                    this.classNameFrom = -1;
                    this.classNameTo = -1;
                    break;
                }
                case IDLE: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || c == '.') break;
                    this.state = ClassNameState.UNDEFINED;
                    break;
                }
                case CLASS_NAME: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || c == '_') break;
                    this.state = ClassNameState.UNDEFINED;
                    this.classNameTo = i;
                }
            }
        }
    }

    static enum CommentState {
        NOT_IN_COMMENT,
        COMMENT_CANDIDATE,
        STRING_LITERAL,
        LINE_COMMENT,
        BLOCK_COMMENT,
        BLOCK_COMMENT_OUT_CANDIDATE;

    }

    static final class CommentMachine {
        CommentState state = CommentState.NOT_IN_COMMENT;

        CommentMachine() {
        }

        void nextChar(char c) {
            switch (this.state) {
                case NOT_IN_COMMENT: {
                    if (c == '\"') {
                        this.state = CommentState.STRING_LITERAL;
                        break;
                    }
                    if (c != '/') break;
                    this.state = CommentState.COMMENT_CANDIDATE;
                    break;
                }
                case COMMENT_CANDIDATE: {
                    if (c == '/') {
                        this.state = CommentState.LINE_COMMENT;
                        break;
                    }
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT;
                    break;
                }
                case STRING_LITERAL: {
                    if (c != '\"') break;
                    this.state = CommentState.NOT_IN_COMMENT;
                    break;
                }
                case LINE_COMMENT: {
                    if (c != '\n') break;
                    this.state = CommentState.NOT_IN_COMMENT;
                    break;
                }
                case BLOCK_COMMENT: {
                    if (c != '*') break;
                    this.state = CommentState.BLOCK_COMMENT_OUT_CANDIDATE;
                    break;
                }
                case BLOCK_COMMENT_OUT_CANDIDATE: {
                    if (c == '/') {
                        this.state = CommentState.NOT_IN_COMMENT;
                        break;
                    }
                    if (c == '*') break;
                    this.state = CommentState.BLOCK_COMMENT;
                    break;
                }
            }
        }

        boolean isInComment() {
            switch (this.state) {
                case STRING_LITERAL: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case BLOCK_COMMENT_OUT_CANDIDATE: {
                    return true;
                }
            }
            return false;
        }
    }

    static enum FullyQualifiedNameState {
        UNDEFINED,
        IDLE,
        PACKAGE_PART_CANDIDATE,
        DOT,
        CLASS,
        FINISH;

    }

    static final class QualifiedNameMachine {
        FullyQualifiedNameState state = FullyQualifiedNameState.UNDEFINED;
        int importFrom = -1;
        int importTo = -1;
        int packageTo = -1;
        boolean allowNestedTypes;

        QualifiedNameMachine() {
        }

        void nextChar(char c, int i) {
            switch (this.state) {
                case UNDEFINED: {
                    if ($PostprocessingMachine.isLowerCaseAlphabetic(c) || $PostprocessingMachine.isUnderscore(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        this.importFrom = i;
                        break;
                    }
                    if (!$PostprocessingMachine.isAlphabetic(c) && !$PostprocessingMachine.isDigit(c) && !$PostprocessingMachine.isUnderscore(c)) break;
                    this.state = FullyQualifiedNameState.IDLE;
                    break;
                }
                case IDLE: {
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || $PostprocessingMachine.isUnderscore(c) || c == '.') break;
                    this.state = FullyQualifiedNameState.UNDEFINED;
                    break;
                }
                case PACKAGE_PART_CANDIDATE: {
                    if (c == '.') {
                        this.state = FullyQualifiedNameState.DOT;
                        break;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || $PostprocessingMachine.isUnderscore(c)) break;
                    this.reset();
                    break;
                }
                case DOT: {
                    if ($PostprocessingMachine.isLowerCaseAlphabetic(c) || $PostprocessingMachine.isUnderscore(c)) {
                        this.state = FullyQualifiedNameState.PACKAGE_PART_CANDIDATE;
                        break;
                    }
                    if ($PostprocessingMachine.isUpperCaseAlphabetic(c)) {
                        this.state = FullyQualifiedNameState.CLASS;
                        break;
                    }
                    this.reset();
                    break;
                }
                case CLASS: {
                    if (this.packageTo == -1) {
                        this.packageTo = i - 1;
                    }
                    if (c == '.' & this.allowNestedTypes) {
                        this.state = FullyQualifiedNameState.DOT;
                        this.packageTo = -1;
                        break;
                    }
                    if ($PostprocessingMachine.isAlphabetic(c) || $PostprocessingMachine.isDigit(c) || $PostprocessingMachine.isUnderscore(c)) break;
                    this.state = FullyQualifiedNameState.FINISH;
                    this.importTo = i;
                    break;
                }
                case FINISH: {
                    this.reset();
                }
            }
        }

        boolean isFinished() {
            return FullyQualifiedNameState.FINISH == this.state;
        }

        QualifiedNameMachine allowNestedTypes() {
            this.allowNestedTypes = true;
            return this;
        }

        void reset() {
            this.state = FullyQualifiedNameState.UNDEFINED;
            this.importFrom = -1;
            this.importTo = -1;
            this.packageTo = -1;
        }
    }

    private static enum ToImportStatement implements $Function<String, String>
    {
        FUNCTION;


        @Override
        public String apply(String input) {
            return "import " + input + ";\n";
        }
    }

    static final class ImportsBuilder {
        private static final int NO_IMPORT = -1;
        private static final String JAVA_LANG = "java.lang.";
        private final TreeSet<String> imports = $Sets.newTreeSet();
        private final HashMap<String, String> originalImports = $Maps.newHashMap();
        private final $Multimap<String, ImportCandidate> importCandidates = $HashMultimap.create();
        private final HashMap<String, String> nameToQualified = $Maps.newHashMap();
        private final HashSet<String> exceptions = $Sets.newHashSet();
        private final HashSet<String> stopList = $Sets.newHashSet();
        private String currentPackagePrefix = "";
        private String currentPackage;

        ImportsBuilder() {
        }

        void addImportCandidate(String name, String qualifiedName, int importFrom, int importTo, int packageTo) {
            String foundQualified = this.nameToQualified.get(name);
            if (foundQualified != null && !foundQualified.equals(qualifiedName)) {
                return;
            }
            this.nameToQualified.put(name, qualifiedName);
            if (this.omittedImport(name, qualifiedName)) {
                importTo = -1;
            }
            this.importCandidates.put(qualifiedName, new ImportCandidate(importFrom, importTo, packageTo, qualifiedName, name));
        }

        void addImport(String importedPackage) {
            this.imports.add(importedPackage);
        }

        void addOriginalImport(String name, String qualifiedName, String importedPackage) {
            this.originalImports.put(name, qualifiedName);
            if (!this.omittedImport(name, qualifiedName)) {
                this.imports.add(importedPackage);
            }
        }

        private boolean omittedImport(String name, String qualifiedName) {
            if ((JAVA_LANG + name).equals(qualifiedName)) {
                return true;
            }
            return qualifiedName.equals(this.currentPackagePrefix.concat(name));
        }

        void addToStopList(String name) {
            this.stopList.add(name);
        }

        void addException(String name) {
            if (!this.stopList.contains(name)) {
                this.exceptions.add(name);
            }
        }

        void setCurrentPackage(String currentPackage) {
            this.currentPackage = currentPackage;
            this.currentPackagePrefix = currentPackage.isEmpty() ? "" : currentPackage + '.';
        }

        void preBuild() {
            for (String string : this.exceptions) {
                String asInCurrentPackage;
                String qualifiedName = this.nameToQualified.get(string);
                if (qualifiedName == null || qualifiedName.equals(asInCurrentPackage = this.currentPackagePrefix.concat(string))) continue;
                this.importCandidates.removeAll(qualifiedName);
            }
            for (Map.Entry entry : this.importCandidates.entries()) {
                ImportCandidate candidate = (ImportCandidate)entry.getValue();
                String originalFullyName = this.originalImports.get(candidate.simpleName);
                if (originalFullyName == null || originalFullyName.equals(candidate.preparedImport)) continue;
                this.importCandidates.remove(entry.getKey(), entry.getValue());
            }
        }

        String build() {
            this.invokeImportModifiers();
            return JOINER.join($Iterables.transform(this.imports, ToImportStatement.FUNCTION));
        }

        private void invokeImportModifiers() {
            for (GeneratedImportsModifier modifier : importsModifiers) {
                modifier.modify(this.currentPackage, this.imports);
            }
        }

        List<ImportCandidate> candidates() {
            return $Ordering.natural().sortedCopy(this.importCandidates.values());
        }
    }

    static final class FiniteStateMachine {
        private static final int NO_POSITION = -1;
        private static final int AT_POSSIBLE_WORD = -1;
        private static final int UNTRACKED_WORD = -2;
        private static final char[][] vocabulary = new char[][]{"package".toCharArray(), "import".toCharArray(), "class".toCharArray(), "interface".toCharArray(), "enum".toCharArray(), "@".toCharArray()};
        private static final State[] finalState = new State[]{State.PACKAGE, State.IMPORTS, State.CLASS, State.CLASS, State.CLASS, State.ANNOTATION};
        int wordIndex;
        int charIndex;

        FiniteStateMachine() {
            this.resetWord();
        }

        State nextChar(char c) {
            State newState = State.UNDEFINED;
            if (this.wordIndex == -2) {
                if (!this.isWordChar(c)) {
                    this.resetWord();
                }
            } else if (this.wordIndex == -1) {
                if (this.isWordChar(c)) {
                    for (int i = 0; i < vocabulary.length; ++i) {
                        if (c != vocabulary[i][0]) continue;
                        this.wordIndex = i;
                        this.charIndex = 0;
                        break;
                    }
                    if (this.wordIndex == -1) {
                        this.wordIndex = -2;
                    }
                }
            } else if (vocabulary[this.wordIndex].length == 1) {
                newState = finalState[this.wordIndex];
                this.resetWord();
            } else if (vocabulary[this.wordIndex][this.charIndex + 1] == c) {
                ++this.charIndex;
                if (vocabulary[this.wordIndex].length == this.charIndex + 1) {
                    newState = finalState[this.wordIndex];
                    this.resetWord();
                }
            } else {
                this.resetWord();
            }
            return newState;
        }

        private void resetWord() {
            this.wordIndex = -1;
            this.charIndex = -1;
        }

        private boolean isWordChar(char c) {
            return $PostprocessingMachine.isAlphabetic(c) || c == '@';
        }
    }

    static enum State {
        UNDEFINED,
        PACKAGE,
        IMPORTS,
        CLASS,
        ANNOTATION;


        State or(State state) {
            return this == UNDEFINED ? state : this;
        }

        public boolean atClassDefinition() {
            return this == ANNOTATION || this == CLASS;
        }

        public boolean pastHeader() {
            return this != UNDEFINED;
        }
    }

    private static enum ScanAtMost {
        HEADER,
        IMPORTS,
        ALL;

    }
}

