/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.BsonWriter;
import org.bson.types.Decimal128;
import org.immutables.mongo.Wrapper;

@NotThreadSafe
public class BsonGenerator
extends GeneratorBase
implements Wrapper<BsonWriter> {
    private final BsonWriter writer;

    BsonGenerator(int jsonFeatures, ObjectCodec codec, BsonWriter writer) {
        super(jsonFeatures, codec);
        this.writer = (BsonWriter)Preconditions.checkNotNull((Object)writer, (Object)"writer");
    }

    public void writeStartArray() throws IOException {
        this.writer.writeStartArray();
    }

    public void writeEndArray() throws IOException {
        this.writer.writeEndArray();
    }

    public void writeStartObject() throws IOException {
        this.writer.writeStartDocument();
    }

    public void writeEndObject() throws IOException {
        this.writer.writeEndDocument();
    }

    public void writeFieldName(String name) throws IOException {
        this.writer.writeName(name);
    }

    public void writeString(String text) throws IOException {
        this.writer.writeString(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writer.writeString(new String(text, offset, len));
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writer.writeString(new String(text, offset, length));
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.writer.writeString(new String(text, offset, length));
    }

    public void writeRaw(String text) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeRaw(char c) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeNumber(int number) throws IOException {
        this.writer.writeInt32(number);
    }

    public void writeNumber(long number) throws IOException {
        this.writer.writeInt64(number);
    }

    public void writeNumber(BigInteger number) throws IOException {
        this.writeNumber(new BigDecimal(number));
    }

    public void writeNumber(double number) throws IOException {
        this.writer.writeDouble(number);
    }

    public void writeNumber(float number) throws IOException {
        this.writer.writeDouble((double)number);
    }

    public void writeNumber(BigDecimal number) throws IOException {
        try {
            this.writer.writeDecimal128(new Decimal128(number));
        }
        catch (NumberFormatException e) {
            this.writer.writeString(number.toString());
        }
    }

    public void writeNumber(String encodedValue) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(boolean state) throws IOException {
        this.writer.writeBoolean(state);
    }

    public void writeNull() throws IOException {
        this.writer.writeNull();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
    }

    @Override
    public BsonWriter unwrap() {
        return this.writer;
    }
}

