/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.bson.AbstractBsonReader;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.mongo.bson4jackson.BsonGenerator;
import org.immutables.mongo.bson4jackson.BsonParser;

@Beta
public final class JacksonCodecs {
    private JacksonCodecs() {
    }

    public static CodecRegistry registryFromMapper(final ObjectMapper mapper) {
        Preconditions.checkNotNull((Object)mapper, (Object)"mapper");
        return new CodecRegistry(){

            public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
                try {
                    return this.get(clazz);
                }
                catch (CodecConfigurationException e) {
                    return null;
                }
            }

            public <T> Codec<T> get(Class<T> clazz) {
                JavaType javaType = TypeFactory.defaultInstance().constructType(clazz);
                if (!mapper.canSerialize(clazz) || !mapper.canDeserialize(javaType)) {
                    throw new CodecConfigurationException(String.format("%s (javaType: %s) not supported by Jackson Mapper", clazz, javaType));
                }
                return new JacksonCodec(clazz, mapper);
            }
        };
    }

    public static <T> JsonSerializer<T> serializer(Codec<T> codec) {
        return new CodecSerializer(codec);
    }

    public static Serializers serializers(final CodecRegistry registry) {
        return new Serializers.Base(){

            public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
                try {
                    Codec codec = registry.get(type.getRawClass());
                    return JacksonCodecs.serializer(codec);
                }
                catch (CodecConfigurationException e) {
                    return null;
                }
            }
        };
    }

    public static Module module(final CodecRegistry registry) {
        Preconditions.checkNotNull((Object)registry, (Object)"registry");
        return new Module(){

            public String getModuleName() {
                return JacksonCodecs.class.getSimpleName();
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.addSerializers(JacksonCodecs.serializers(registry));
            }
        };
    }

    private static class CodecSerializer<T>
    extends StdSerializer<T> {
        private final Codec<T> codec;

        private CodecSerializer(Codec<T> codec) {
            super(codec.getEncoderClass());
            this.codec = codec;
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            BsonWriter writer = ((BsonGenerator)gen).unwrap();
            this.codec.encode(writer, value, EncoderContext.builder().build());
        }
    }

    private static class JacksonCodec<T>
    implements Codec<T> {
        private final Class<T> clazz;
        private final ObjectMapper mapper;

        private JacksonCodec(Class<T> clazz, ObjectMapper mapper) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"mapper");
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            IOContext ioContext = new IOContext(new BufferRecycler(), ContentReference.unknown(), false);
            BsonParser parser = new BsonParser(ioContext, 0, (AbstractBsonReader)reader);
            try {
                return (T)this.mapper.readValue((JsonParser)parser, this.getEncoderClass());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            BsonGenerator generator = new BsonGenerator(0, (ObjectCodec)this.mapper, writer);
            try {
                this.mapper.writerFor(this.getEncoderClass()).writeValue((JsonGenerator)generator, value);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't serialize [" + value + "] as " + this.getEncoderClass(), e);
            }
        }

        public Class<T> getEncoderClass() {
            return this.clazz;
        }
    }
}

