/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository.internal;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.repository.internal.Constraints;

public final class Support {
    private Support() {
    }

    public static Bson convertToBson(Constraints.ConstraintHost fields) {
        if (fields instanceof JsonQuery) {
            return (Bson)fields;
        }
        return fields.accept(new ConstraintBuilder("")).asDocument();
    }

    public static Bson convertToIndex(Constraints.ConstraintHost fields) {
        Document document = new Document();
        fields.accept(new ConvertToIndex(document));
        return document;
    }

    public static String stringify(Constraints.ConstraintHost constraints) {
        if (constraints instanceof JsonQuery) {
            return constraints.toString();
        }
        return Support.convertToBson(constraints).toString();
    }

    public static Constraints.ConstraintHost jsonQuery(String query) {
        return new JsonQuery(Document.parse((String)query));
    }

    public static <T> Object writable(Encoder<T> encoder, T value) {
        return new Adapted<T>(encoder, value);
    }

    public static Object writable(Object value) {
        return value;
    }

    public static <T extends Comparable<? super T>> Range<Comparable<Object>> writable(Encoder<T> encoder, Range<T> range) {
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return Range.range((Comparable)((Comparable)Support.writable(encoder, range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)Support.writable(encoder, range.upperEndpoint())), (BoundType)range.upperBoundType());
        }
        if (range.hasLowerBound()) {
            return Range.downTo((Comparable)((Comparable)Support.writable(encoder, range.lowerEndpoint())), (BoundType)range.lowerBoundType());
        }
        if (range.hasUpperBound()) {
            return Range.upTo((Comparable)((Comparable)Support.writable(encoder, range.upperEndpoint())), (BoundType)range.upperBoundType());
        }
        throw new AssertionError();
    }

    public static <T extends Comparable<? super T>> Range<Comparable<Object>> writable(Range<T> range) {
        return (Range)Support.writable(range);
    }

    public static Object unwrapBsonable(Object value) {
        if (value instanceof Document) {
            for (Map.Entry entry : ((Document)value).entrySet()) {
                entry.setValue(Support.unwrapBsonable(entry.getValue()));
            }
            return value;
        }
        if (value instanceof Iterable) {
            return ImmutableList.copyOf(Support.unwrapBsonableIterable((Iterable)value));
        }
        if (value instanceof Constraints.ConstraintHost) {
            return Support.convertToBson((Constraints.ConstraintHost)value);
        }
        if (value == null || value instanceof Number || value instanceof Boolean || value instanceof String) {
            return value;
        }
        if (value instanceof Adapted) {
            return ((Adapted)value).toBson();
        }
        return String.valueOf(value);
    }

    static Iterable<?> unwrapBsonableIterable(Iterable<?> values) {
        return Iterables.transform(values, (Function)new Function<Object, Object>(){

            public Object apply(Object input) {
                return Support.unwrapBsonable(input);
            }
        });
    }

    public static Object emptyBsonObject() {
        return new Document();
    }

    public static Object bsonObjectAttribute(String name, Object value) {
        return new Document(name, value);
    }

    private static class JsonQuery
    implements Constraints.ConstraintHost,
    Bson {
        private final Document value;

        JsonQuery(Document value) {
            this.value = (Document)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        public String toString() {
            return this.value.toJson();
        }

        @Override
        public <V extends Constraints.ConstraintVisitor<V>> V accept(V visitor) {
            throw new UnsupportedOperationException("Satisfied ConstraintSupport.ConstraintHost only for technical reasons and don't implements accept");
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            return this.value.toBsonDocument(tDocumentClass, codecRegistry);
        }
    }

    @NotThreadSafe
    public static class ConstraintBuilder
    extends Constraints.AbstractConstraintVisitor<ConstraintBuilder> {
        private final String keyPrefix;
        private List<Document> conjunctions;
        private final List<Document> disjunctions;
        private static final String[][] comparisonOperators = new String[][]{{"$lt", "$lte"}, {"$gt", "$gte"}};

        private ConstraintBuilder(String keyPrefix) {
            this.keyPrefix = (String)Preconditions.checkNotNull((Object)keyPrefix, (Object)"keyPrefix");
            this.conjunctions = new ArrayList<Document>();
            this.disjunctions = new ArrayList<Document>();
        }

        private ConstraintBuilder newBuilderForKey(String key) {
            return new ConstraintBuilder(this.keyPrefix + "." + key);
        }

        private void addContraint(String name, Object constraint) {
            String path = this.keyPrefix.concat(name);
            this.conjunctions.add(new Document(path, constraint));
        }

        @Override
        public ConstraintBuilder in(String name, boolean negate, Iterable<?> values) {
            this.addContraint(name, new Document(negate ? "$nin" : "$in", (Object)ImmutableSet.copyOf(Support.unwrapBsonableIterable(values))));
            return this;
        }

        @Override
        public ConstraintBuilder equal(String name, boolean negate, @Nullable Object value) {
            this.addContraint(name, negate ? new Document("$ne", Support.unwrapBsonable(value)) : Support.unwrapBsonable(value));
            return this;
        }

        @Override
        public ConstraintBuilder range(String name, boolean negate, Range<?> range) {
            if (range.hasLowerBound() && range.hasUpperBound()) {
                if (range.lowerEndpoint().equals(range.upperEndpoint()) && !range.isEmpty()) {
                    this.equal(name, negate, range.lowerEndpoint());
                } else {
                    Document rangeObject = new Document().append(this.boundToOperator(true, false, range.lowerBoundType()), Support.unwrapBsonable(range.lowerEndpoint())).append(this.boundToOperator(false, false, range.upperBoundType()), Support.unwrapBsonable(range.upperEndpoint()));
                    this.addContraint(name, this.negateConstraint(negate, rangeObject));
                }
            } else if (range.hasLowerBound()) {
                Document rangeObject = new Document(this.boundToOperator(true, negate, range.lowerBoundType()), Support.unwrapBsonable(range.lowerEndpoint()));
                this.addContraint(name, rangeObject);
            } else if (range.hasUpperBound()) {
                Document rangeObject = new Document(this.boundToOperator(false, negate, range.upperBoundType()), Support.unwrapBsonable(range.upperEndpoint()));
                this.addContraint(name, rangeObject);
            }
            return this;
        }

        private String boundToOperator(boolean lower, boolean negate, BoundType lowerBoundType) {
            boolean closedBound = lowerBoundType == BoundType.CLOSED;
            return comparisonOperators[lower ^ negate ? 1 : 0][closedBound ^ negate ? 1 : 0];
        }

        private Object negateConstraint(boolean negate, Object constraint) {
            return negate ? new Document("$not", constraint) : constraint;
        }

        public Document asDocument() {
            ArrayList<Document> result = new ArrayList<Document>(this.disjunctions);
            result.add(this.mergeConjunctions(this.conjunctions));
            return result.size() == 1 ? (Document)result.get(0) : new Document("$or", result);
        }

        private Document mergeConjunctions(List<Document> conjunctions) {
            LinkedHashMultimap merged = LinkedHashMultimap.create();
            for (Document doc : conjunctions) {
                Preconditions.checkState((doc.keySet().size() == 1 ? 1 : 0) != 0, (String)"Invalid constraint %s", (Object)doc);
                String key = (String)doc.keySet().iterator().next();
                merged.put((Object)key, (Object)doc);
            }
            Document result = new Document();
            for (Map.Entry entry : merged.asMap().entrySet()) {
                Preconditions.checkState((!((Collection)entry.getValue()).isEmpty() ? 1 : 0) != 0, (String)"empty constraint: %s", entry);
                if (((Collection)entry.getValue()).size() == 1) {
                    result.putAll((Map)((Collection)entry.getValue()).iterator().next());
                    continue;
                }
                result.putAll((Map)new Document("$and", entry.getValue()));
            }
            return result;
        }

        @Override
        public ConstraintBuilder size(String name, boolean negate, int size) {
            this.addContraint(name, this.negateConstraint(negate, new Document("$size", (Object)size)));
            return this;
        }

        @Override
        public ConstraintBuilder present(String name, boolean negate) {
            this.addContraint(name, new Document("$exists", (Object)(!negate ? 1 : 0)));
            return this;
        }

        @Override
        public ConstraintBuilder match(String name, boolean negate, Pattern pattern) {
            this.addContraint(name, this.negateConstraint(negate, pattern));
            return this;
        }

        @Override
        public ConstraintBuilder nested(String name, Constraints.ConstraintHost nestedConstraints) {
            this.conjunctions.add(nestedConstraints.accept(this.newBuilderForKey(name)).asDocument());
            return this;
        }

        @Override
        public ConstraintBuilder disjunction() {
            this.disjunctions.add(this.mergeConjunctions(this.conjunctions));
            this.conjunctions = new ArrayList<Document>();
            return this;
        }
    }

    private static final class ConvertToIndex
    extends Constraints.AbstractConstraintVisitor<ConvertToIndex> {
        private final Document document;

        private ConvertToIndex(Document document) {
            this.document = document;
        }

        @Override
        public ConvertToIndex equal(String name, boolean negate, @Nullable Object value) {
            if (this.document.containsKey((Object)name)) {
                throw new IllegalArgumentException(String.format("Attribute %s is not unique: %s", name, this.document.get((Object)name)));
            }
            this.document.put(name, value);
            return this;
        }
    }

    static final class Adapted<T>
    implements Comparable<Adapted<T>> {
        final T value;
        final Encoder<T> encoder;

        Adapted(Encoder<T> encoder, T value) {
            this.encoder = encoder;
            this.value = value;
        }

        BsonValue toBson() {
            BsonDocument bson = new BsonDocument();
            BsonDocumentWriter writer = new BsonDocumentWriter(bson);
            writer.writeStartDocument();
            writer.writeName("$");
            this.encoder.encode((BsonWriter)writer, this.value, EncoderContext.builder().build());
            writer.writeEndDocument();
            writer.flush();
            return bson.get((Object)"$");
        }

        @Override
        public int compareTo(Adapted<T> o) {
            return ((Comparable)this.value).compareTo(o.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue(this.value).toString();
        }
    }
}

