/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.AbstractBsonReader;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.immutables.mongo.Wrapper;

@NotThreadSafe
public class BsonParser
extends ParserBase
implements Wrapper<BsonReader> {
    private final AbstractBsonReader reader;
    private ObjectCodec _codec;

    BsonParser(IOContext ctxt, int jsonFeatures, AbstractBsonReader reader) {
        super(ctxt, jsonFeatures);
        this.reader = (AbstractBsonReader)Preconditions.checkNotNull((Object)reader, (Object)"reader");
    }

    protected void _closeInput() throws IOException {
        if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
            this.reader.close();
        }
        this._closed = true;
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec codec) {
        this._codec = codec;
    }

    private AbstractBsonReader.State state() {
        return this.reader.getState();
    }

    public String nextFieldName() throws IOException {
        if (this.next() == JsonToken.FIELD_NAME) {
            return this.reader.readName();
        }
        return null;
    }

    public String getCurrentName() throws IOException {
        if (this.state() == AbstractBsonReader.State.NAME) {
            return this.nextFieldName();
        }
        if (this.state() == AbstractBsonReader.State.VALUE) {
            return this.reader.getCurrentName();
        }
        return null;
    }

    public Number getNumberValue() throws IOException {
        BsonType type = this.type();
        switch (type) {
            case DOUBLE: {
                return this.reader.readDouble();
            }
            case INT32: {
                return this.reader.readInt32();
            }
            case INT64: {
                return this.reader.readInt64();
            }
            case DECIMAL128: {
                return this.reader.readDecimal128().bigDecimalValue();
            }
            case STRING: {
                return new BigDecimal(this.reader.readString());
            }
        }
        throw new IllegalStateException(String.format("Can't convert %s to %s", type, Number.class.getName()));
    }

    public BigInteger getBigIntegerValue() throws IOException {
        Number value = this.getNumberValue();
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        return BigInteger.valueOf(value.longValue());
    }

    public float getFloatValue() throws IOException {
        return this.getNumberValue().floatValue();
    }

    public double getDoubleValue() throws IOException {
        return this.getNumberValue().doubleValue();
    }

    public int getIntValue() throws IOException {
        return this.getNumberValue().intValue();
    }

    public long getLongValue() throws IOException {
        return this.getNumberValue().longValue();
    }

    public BigDecimal getDecimalValue() throws IOException {
        BsonType type = this.type();
        switch (type) {
            case DOUBLE: {
                return BigDecimal.valueOf(this.getNumberValue().doubleValue());
            }
            case INT32: {
                return new BigDecimal(this.getNumberValue().intValue());
            }
            case INT64: {
                return BigDecimal.valueOf(this.getNumberValue().longValue());
            }
            case DECIMAL128: 
            case STRING: {
                return (BigDecimal)this.getNumberValue();
            }
        }
        throw new IllegalStateException(String.format("Can't convert %s to %s", type, BigDecimal.class.getName()));
    }

    private BsonType type() {
        return this.reader.getCurrentBsonType();
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        BsonType type = this.type();
        switch (type) {
            case DOUBLE: {
                return JsonParser.NumberType.DOUBLE;
            }
            case INT32: {
                return JsonParser.NumberType.INT;
            }
            case INT64: {
                return JsonParser.NumberType.LONG;
            }
            case DECIMAL128: {
                return JsonParser.NumberType.BIG_DECIMAL;
            }
        }
        throw new IllegalStateException(String.format("Not a number type %s", type));
    }

    public JsonToken nextToken() throws IOException {
        this._currToken = this.next();
        return this._currToken;
    }

    private JsonToken next() {
        while (this.state() == AbstractBsonReader.State.TYPE) {
            this.reader.readBsonType();
        }
        switch (this.state()) {
            case INITIAL: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case NAME: {
                return JsonToken.FIELD_NAME;
            }
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case END_OF_ARRAY: {
                this.reader.readEndArray();
                return JsonToken.END_ARRAY;
            }
            case DONE: {
                return null;
            }
            case VALUE: {
                return this.toJsonToken(this.type());
            }
        }
        throw new IllegalStateException(String.format("Unexpected state: %s currentType: %s", this.state(), this.type()));
    }

    private JsonToken toJsonToken(BsonType type) {
        switch (type) {
            case END_OF_DOCUMENT: {
                this.reader.readEndDocument();
                return JsonToken.END_OBJECT;
            }
            case DOCUMENT: {
                this.reader.readStartDocument();
                return JsonToken.START_OBJECT;
            }
            case ARRAY: {
                this.reader.readStartArray();
                return JsonToken.START_ARRAY;
            }
            case OBJECT_ID: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case BOOLEAN: {
                boolean value = this.reader.readBoolean();
                return value ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
            }
            case DATE_TIME: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case NULL: {
                this.reader.readNull();
                return JsonToken.VALUE_NULL;
            }
            case REGULAR_EXPRESSION: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
            case STRING: 
            case SYMBOL: {
                return JsonToken.VALUE_STRING;
            }
            case INT32: 
            case INT64: {
                return JsonToken.VALUE_NUMBER_INT;
            }
            case DECIMAL128: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case DOUBLE: {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            case BINARY: {
                return JsonToken.VALUE_EMBEDDED_OBJECT;
            }
        }
        throw new IllegalStateException(String.format("Unknown type %s", type));
    }

    public String getText() throws IOException {
        BsonType type = this.type();
        if (type == BsonType.SYMBOL) {
            return this.reader.readSymbol();
        }
        if (type == BsonType.STRING) {
            return this.reader.readString();
        }
        throw new IllegalStateException(String.format("Bad BSON type: %s expected String or Symbol", type));
    }

    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BsonReader unwrap() {
        return this.reader;
    }
}

