/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4gson;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mongodb.MongoClientSettings;
import java.io.IOException;
import org.bson.AbstractBsonReader;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.mongo.bson4gson.BsonReader;
import org.immutables.mongo.bson4gson.BsonWriter;

public final class GsonCodecs {
    private GsonCodecs() {
    }

    public static <T> TypeAdapter<T> typeAdapterFromCodec(final Codec<T> codec) {
        Preconditions.checkNotNull(codec, (Object)"codec");
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                BsonWriter writer = (BsonWriter)out;
                org.bson.BsonWriter delegate = writer.unwrap();
                codec.encode(delegate, value, EncoderContext.builder().build());
            }

            public T read(JsonReader in) throws IOException {
                BsonReader reader = (BsonReader)in;
                org.bson.BsonReader delegate = reader.unwrap();
                return codec.decode(delegate, DecoderContext.builder().build());
            }
        };
    }

    public static TypeAdapterFactory delegatingTypeAdapterFactory(final CodecRegistry registry) {
        Preconditions.checkNotNull((Object)registry, (Object)"registry");
        return new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                boolean hasAdapter;
                try {
                    TypeAdapter adapter = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
                    hasAdapter = !GsonCodecs.isReflectiveTypeAdapter(adapter);
                }
                catch (IllegalArgumentException e) {
                    hasAdapter = false;
                }
                if (hasAdapter) {
                    return null;
                }
                try {
                    Codec codec = registry.get(type.getRawType());
                    return GsonCodecs.typeAdapterFromCodec(codec);
                }
                catch (CodecConfigurationException e1) {
                    return null;
                }
            }
        };
    }

    public static <T> Codec<T> codecFromTypeAdapter(Class<T> type, TypeAdapter<T> adapter) {
        if (GsonCodecs.isReflectiveTypeAdapter(adapter)) {
            throw new CodecConfigurationException(String.format("%s can't be build from %s (for type %s)", TypeAdapterCodec.class.getSimpleName(), adapter.getClass().getName(), type.getName()));
        }
        return new TypeAdapterCodec(type, adapter);
    }

    public static CodecRegistry codecRegistryFromGson(final Gson gson) {
        Preconditions.checkNotNull((Object)gson, (Object)"gson");
        return new CodecRegistry(){

            public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
                try {
                    return this.get(clazz);
                }
                catch (CodecConfigurationException e) {
                    return null;
                }
            }

            public <T> Codec<T> get(Class<T> clazz) {
                return GsonCodecs.codecFromTypeAdapter(clazz, gson.getAdapter(clazz));
            }
        };
    }

    public static Gson newGsonWithBsonSupport(Gson gson) {
        TypeAdapterFactory bsonAdapterFactory = GsonCodecs.delegatingTypeAdapterFactory(MongoClientSettings.getDefaultCodecRegistry());
        return gson.newBuilder().registerTypeAdapterFactory(bsonAdapterFactory).create();
    }

    static <A> boolean isReflectiveTypeAdapter(TypeAdapter<A> adapter) {
        Preconditions.checkNotNull(adapter, (Object)"adapter");
        return adapter instanceof ReflectiveTypeAdapterFactory.Adapter;
    }

    private static class TypeAdapterCodec<T>
    implements Codec<T> {
        private final Class<T> clazz;
        private final TypeAdapter<T> adapter;

        private TypeAdapterCodec(Class<T> type, TypeAdapter<T> adapter) {
            this.clazz = (Class)Preconditions.checkNotNull(type, (Object)"type");
            Preconditions.checkArgument((!GsonCodecs.isReflectiveTypeAdapter(adapter) ? 1 : 0) != 0, (String)"Type adapter %s for type '%s' is not supported. This may happen when using default RepositorySetup.forUri and META-INF/services/..TypeAdapterFactory files are not compiled or accessible. Alternatively this may happen if creating custom RepositorySetup with Gson instance, which does not have type adapters registered.", (Object[])new Object[]{adapter.getClass().getName(), type});
            this.adapter = adapter;
        }

        public T decode(org.bson.BsonReader reader, DecoderContext decoderContext) {
            if (!(reader instanceof AbstractBsonReader)) {
                throw new UnsupportedOperationException(String.format("Only readers of type %s supported. Yours is %s", AbstractBsonReader.class.getName(), reader.getClass().getName()));
            }
            try {
                return (T)this.adapter.read((JsonReader)new BsonReader((AbstractBsonReader)reader));
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Couldn't read %s", this.clazz), e);
            }
        }

        public void encode(org.bson.BsonWriter writer, T value, EncoderContext encoderContext) {
            try {
                this.adapter.write((JsonWriter)new BsonWriter(writer), value);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Couldn't write value of class %s: %s", this.clazz.getName(), value), e);
            }
        }

        public Class<T> getEncoderClass() {
            return this.clazz;
        }
    }
}

