/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.types;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Binary {
    private final byte[] data;

    private Binary(byte[] data) {
        this.data = data;
    }

    public static Binary create(byte[] data) {
        return new Binary((byte[])data.clone());
    }

    public byte[] value() {
        return (byte[])this.data.clone();
    }

    public int length() {
        return this.data.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Binary) {
            Binary binary = (Binary)other;
            return Arrays.equals(this.data, binary.data);
        }
        return false;
    }

    public String toString() {
        return "Binary(" + this.data.length + " bytes)";
    }
}

