/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.primitives.UnsignedInteger;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.ImmutableSillyEntity;
import org.immutables.fixture.SillyEntity;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture", generator="Gsons")
public final class GsonAdaptersSillyEntity
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (SillyEntityTypeAdapter.adapts(type)) {
            return new SillyEntityTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersSillyEntity(SillyEntity)";
    }

    @Generated(from="SillyEntity", generator="Gsons")
    private static class SillyEntityTypeAdapter
    extends TypeAdapter<SillyEntity> {
        public final Integer payloadSecondaryTypeSample = null;
        public final Integer intsTypeSample = null;
        public final UnsignedInteger derTypeSample = null;
        private final TypeAdapter<Integer> payloadSecondaryTypeAdapter;
        private final TypeAdapter<Integer> intsTypeAdapter;
        private final TypeAdapter<UnsignedInteger> derTypeAdapter;

        SillyEntityTypeAdapter(Gson gson) {
            this.payloadSecondaryTypeAdapter = gson.getAdapter(Integer.class);
            this.intsTypeAdapter = gson.getAdapter(Integer.class);
            this.derTypeAdapter = gson.getAdapter(UnsignedInteger.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return SillyEntity.class == type.getRawType() || ImmutableSillyEntity.class == type.getRawType();
        }

        public void write(JsonWriter out, SillyEntity value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeSillyEntity(out, value);
            }
        }

        public SillyEntity read(JsonReader in) throws IOException {
            return this.readSillyEntity(in);
        }

        private void writeSillyEntity(JsonWriter out, SillyEntity instance) throws IOException {
            out.beginObject();
            out.name("_id");
            out.value((long)instance.id());
            out.name("v");
            out.value(instance.val());
            Map<String, Integer> payloadMapping = instance.payload();
            out.name("p");
            out.beginObject();
            for (Map.Entry<String, Integer> e : payloadMapping.entrySet()) {
                String key = e.getKey();
                out.name(key);
                int value = e.getValue();
                this.payloadSecondaryTypeAdapter.write(out, (Object)value);
            }
            out.endObject();
            List<Integer> intsElements = instance.ints();
            out.name("i");
            out.beginArray();
            for (Integer e : intsElements) {
                this.intsTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.name("der");
            this.derTypeAdapter.write(out, (Object)instance.der());
            out.endObject();
        }

        private SillyEntity readSillyEntity(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableSillyEntity.Builder builder = ImmutableSillyEntity.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableSillyEntity.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if (!"_id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'v': {
                    if (!"v".equals(attributeName)) break;
                    this.readInVal(in, builder);
                    return;
                }
                case 'p': {
                    if (!"p".equals(attributeName)) break;
                    this.readInPayload(in, builder);
                    return;
                }
                case 'i': {
                    if (!"i".equals(attributeName)) break;
                    this.readInInts(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableSillyEntity.Builder builder) throws IOException {
            builder.id(in.nextInt());
        }

        private void readInVal(JsonReader in, ImmutableSillyEntity.Builder builder) throws IOException {
            builder.val(in.nextString());
        }

        private void readInPayload(JsonReader in, ImmutableSillyEntity.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Integer value = (Integer)this.payloadSecondaryTypeAdapter.read(in);
                    builder.putPayload(key, value);
                }
                in.endObject();
            }
        }

        private void readInInts(JsonReader in, ImmutableSillyEntity.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addInts(in.nextInt());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addInts(in.nextInt());
            }
        }
    }
}

