/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.HasNullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HasNullable", generator="Immutables")
@Immutable
public final class ImmutableHasNullable
extends HasNullable {
    @Nullable
    private final Integer in;
    @Nullable
    private final String def;
    @Nullable
    private final transient String der;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableHasNullable INSTANCE = ImmutableHasNullable.validate(new ImmutableHasNullable());

    private ImmutableHasNullable() {
        this.in = null;
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(@Nullable Integer in) {
        this.in = in;
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(Builder builder) {
        this.in = builder.in;
        if (builder.defIsSet()) {
            this.initShim.def(builder.def);
        }
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    private ImmutableHasNullable(@Nullable Integer in, @Nullable String def) {
        this.in = in;
        this.initShim.def(def);
        this.def = this.initShim.def();
        this.der = this.initShim.der();
        this.initShim = null;
    }

    @Override
    @Nullable
    public Integer in() {
        return this.in;
    }

    @Override
    @Nullable
    public String def() {
        InitShim shim = this.initShim;
        return shim != null ? shim.def() : this.def;
    }

    @Override
    @Nullable
    public String der() {
        InitShim shim = this.initShim;
        return shim != null ? shim.der() : this.der;
    }

    public final ImmutableHasNullable withIn(@Nullable Integer value) {
        if (Objects.equals(this.in, value)) {
            return this;
        }
        return ImmutableHasNullable.validate(new ImmutableHasNullable(value, this.def));
    }

    public final ImmutableHasNullable withDef(@Nullable String value) {
        if (Objects.equals(this.def, value)) {
            return this;
        }
        return ImmutableHasNullable.validate(new ImmutableHasNullable(this.in, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHasNullable && this.equalTo(0, (ImmutableHasNullable)another);
    }

    private boolean equalTo(int synthetic, ImmutableHasNullable another) {
        return Objects.equals(this.in, another.in) && Objects.equals(this.def, another.def) && Objects.equals(this.der, another.der);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.in);
        h += (h << 5) + Objects.hashCode(this.def);
        h += (h << 5) + Objects.hashCode(this.der);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HasNullable").omitNullValues().add("in", (Object)this.in).add("def", (Object)this.def).add("der", (Object)this.der).toString();
    }

    public static ImmutableHasNullable of() {
        return INSTANCE;
    }

    public static ImmutableHasNullable of(@Nullable Integer in) {
        return ImmutableHasNullable.validate(new ImmutableHasNullable(in));
    }

    private static ImmutableHasNullable validate(ImmutableHasNullable instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableHasNullable copyOf(HasNullable instance) {
        if (instance instanceof ImmutableHasNullable) {
            return (ImmutableHasNullable)instance;
        }
        return ImmutableHasNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HasNullable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_DEF = 1L;
        private long optBits;
        @Nullable
        private Integer in;
        @Nullable
        private String def;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HasNullable instance) {
            String defValue;
            Objects.requireNonNull(instance, "instance");
            Integer inValue = instance.in();
            if (inValue != null) {
                this.in(inValue);
            }
            if ((defValue = instance.def()) != null) {
                this.def(defValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder in(@Nullable Integer in) {
            this.in = in;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder def(@Nullable String def) {
            this.def = def;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableHasNullable build() {
            return ImmutableHasNullable.validate(new ImmutableHasNullable(this));
        }

        private boolean defIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="HasNullable", generator="Immutables")
    private final class InitShim {
        private byte defBuildStage = 0;
        private String def;
        private byte derBuildStage = 0;
        private String der;

        private InitShim() {
        }

        String def() {
            if (this.defBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defBuildStage == 0) {
                this.defBuildStage = (byte)-1;
                this.def = ImmutableHasNullable.super.def();
                this.defBuildStage = 1;
            }
            return this.def;
        }

        void def(String def) {
            this.def = def;
            this.defBuildStage = 1;
        }

        String der() {
            if (this.derBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.derBuildStage == 0) {
                this.derBuildStage = (byte)-1;
                this.der = ImmutableHasNullable.super.der();
                this.derBuildStage = 1;
            }
            return this.der;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.defBuildStage == -1) {
                attributes.add("def");
            }
            if (this.derBuildStage == -1) {
                attributes.add("der");
            }
            return "Cannot build HasNullable, attribute initializers form cycle " + attributes;
        }
    }
}

