/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.JsonIgnore;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonIgnore", generator="Immutables")
@Immutable
public final class ImmutableJsonIgnore
implements JsonIgnore {
    private final int value;
    private final ImmutableList<Integer> values;

    private ImmutableJsonIgnore(int value) {
        this.value = value;
        this.values = ImmutableList.of();
    }

    private ImmutableJsonIgnore(int value, ImmutableList<Integer> values) {
        this.value = value;
        this.values = values;
    }

    @Override
    public int value() {
        return this.value;
    }

    public ImmutableList<Integer> values() {
        return this.values;
    }

    public final ImmutableJsonIgnore withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableJsonIgnore(value, this.values);
    }

    public final ImmutableJsonIgnore withValues(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableJsonIgnore(this.value, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableJsonIgnore withValues(Iterable<Integer> elements) {
        if (this.values == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJsonIgnore(this.value, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonIgnore && this.equalTo(0, (ImmutableJsonIgnore)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonIgnore another) {
        return this.value == another.value && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value;
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonIgnore").omitNullValues().add("value", this.value).add("values", this.values).toString();
    }

    public static ImmutableJsonIgnore of(int value) {
        return new ImmutableJsonIgnore(value);
    }

    public static ImmutableJsonIgnore copyOf(JsonIgnore instance) {
        if (instance instanceof ImmutableJsonIgnore) {
            return (ImmutableJsonIgnore)instance;
        }
        return ImmutableJsonIgnore.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JsonIgnore", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;
        private ImmutableList.Builder<Integer> values = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonIgnore instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.addAllValues(instance.values());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(int element) {
            this.values.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addValues(int ... elements) {
            this.values.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder values(Iterable<Integer> elements) {
            this.values = ImmutableList.builder();
            return this.addAllValues(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllValues(Iterable<Integer> elements) {
            this.values.addAll(elements);
            return this;
        }

        public ImmutableJsonIgnore build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonIgnore(this.value, this.values.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build JsonIgnore, some of required attributes are not set " + attributes;
        }
    }
}

