/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SampleValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SampleValue", generator="Immutables")
@Immutable
public final class ImmutableSampleValue
implements SampleValue {
    private final int a;
    private final ImmutableList<Integer> c;
    @Nullable
    private final Integer oi;
    private final Optional<String> os;

    private ImmutableSampleValue(int a, ImmutableList<Integer> c, @Nullable Integer oi, Optional<String> os) {
        this.a = a;
        this.c = c;
        this.oi = oi;
        this.os = os;
    }

    @Override
    public int a() {
        return this.a;
    }

    public ImmutableList<Integer> c() {
        return this.c;
    }

    @Override
    public OptionalInt oi() {
        return this.oi != null ? OptionalInt.of(this.oi) : OptionalInt.empty();
    }

    @Override
    public Optional<String> os() {
        return this.os;
    }

    public final ImmutableSampleValue withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableSampleValue(value, this.c, this.oi, this.os);
    }

    public final ImmutableSampleValue withC(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSampleValue(this.a, (ImmutableList<Integer>)newValue, this.oi, this.os);
    }

    public final ImmutableSampleValue withC(Iterable<Integer> elements) {
        if (this.c == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSampleValue(this.a, (ImmutableList<Integer>)newValue, this.oi, this.os);
    }

    public final ImmutableSampleValue withOi(int value) {
        Integer newValue = value;
        if (Objects.equals(this.oi, newValue)) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, newValue, this.os);
    }

    public final ImmutableSampleValue withOi(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.oi, value)) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, value, this.os);
    }

    public final ImmutableSampleValue withOs(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.os.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, this.oi, (Optional<String>)newValue);
    }

    public final ImmutableSampleValue withOs(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.os.equals(value)) {
            return this;
        }
        return new ImmutableSampleValue(this.a, this.c, this.oi, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSampleValue && this.equalTo(0, (ImmutableSampleValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSampleValue another) {
        return this.a == another.a && this.c.equals(another.c) && Objects.equals(this.oi, another.oi) && this.os.equals(another.os);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.c.hashCode();
        h += (h << 5) + Objects.hashCode(this.oi);
        h += (h << 5) + this.os.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SampleValue").omitNullValues().add("a", this.a).add("c", this.c).add("oi", (Object)this.oi).add("os", this.os.orNull()).toString();
    }

    public static ImmutableSampleValue copyOf(SampleValue instance) {
        if (instance instanceof ImmutableSampleValue) {
            return (ImmutableSampleValue)instance;
        }
        return ImmutableSampleValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SampleValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        private int a;
        private ImmutableList.Builder<Integer> c = ImmutableList.builder();
        @Nullable
        private Integer oi;
        private Optional<String> os = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SampleValue instance) {
            Optional<String> osOptional;
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.addAllC(instance.c());
            OptionalInt oiOptional = instance.oi();
            if (oiOptional.isPresent()) {
                this.oi(oiOptional);
            }
            if ((osOptional = instance.os()).isPresent()) {
                this.os(osOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addC(int element) {
            this.c.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addC(int ... elements) {
            this.c.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder c(Iterable<Integer> elements) {
            this.c = ImmutableList.builder();
            return this.addAllC(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllC(Iterable<Integer> elements) {
            this.c.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oi(int oi) {
            this.oi = oi;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oi(OptionalInt oi) {
            this.oi = oi.isPresent() ? Integer.valueOf(oi.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder os(String os) {
            this.os = Optional.of((Object)os);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder os(Optional<String> os) {
            this.os = os;
            return this;
        }

        public ImmutableSampleValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSampleValue(this.a, this.c.build(), this.oi, this.os);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build SampleValue, some of required attributes are not set " + attributes;
        }
    }
}

