/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.annotation.An;
import org.immutables.fixture.annotation.Be;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="An", generator="Immutables")
@Immutable
final class ImmutableAn
implements An {
    private static final Be[] DEFAULT_VALUE_BEES;
    private final int value;
    private final Be[] bees;

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private ImmutableAn(int value) {
        this.value = value;
        this.bees = DEFAULT_VALUE_BEES;
    }

    private ImmutableAn(Builder builder) {
        this.value = builder.value;
        this.bees = builder.bees != null ? builder.bees : DEFAULT_VALUE_BEES;
    }

    private ImmutableAn(int value, Be[] bees) {
        this.value = value;
        this.bees = bees;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return An.class;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public Be[] bees() {
        return (Be[])this.bees.clone();
    }

    public final ImmutableAn withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableAn(value, this.bees);
    }

    public final ImmutableAn withBees(Be ... elements) {
        Be[] newValue = (Be[])elements.clone();
        return new ImmutableAn(this.value, newValue);
    }

    @Override
    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof An && this.equalTo(0, (An)another);
    }

    private boolean equalTo(int synthetic, An another) {
        return this.value == another.value() && Arrays.equals(this.bees, another.bees());
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value;
        return h += 127 * "bees".hashCode() ^ Arrays.hashCode(this.bees);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"@An").omitNullValues().add("value", this.value).add("bees", (Object)Arrays.toString(this.bees)).toString();
    }

    public static ImmutableAn of(int value) {
        return new ImmutableAn(value);
    }

    public static ImmutableAn copyOf(An instance) {
        if (instance instanceof ImmutableAn) {
            return (ImmutableAn)instance;
        }
        return ImmutableAn.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        try {
            DEFAULT_VALUE_BEES = (Be[])ImmutableAn.cast(An.class.getDeclaredMethod("bees", new Class[0]).getDefaultValue());
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Generated(from="An", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;
        @Nullable
        private Be[] bees;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(An instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.bees(instance.bees());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bees(Be ... bees) {
            this.bees = (Be[])bees.clone();
            return this;
        }

        public ImmutableAn build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAn(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build An, some of required attributes are not set " + attributes;
        }
    }
}

