/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.ast;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ast.InstantiationGenerics;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstantiationGenerics.StringLeaf", generator="Immutables")
@Immutable
public final class ImmutableStringLeaf
implements InstantiationGenerics.StringLeaf {
    private final String value;

    private ImmutableStringLeaf(String value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableStringLeaf(ImmutableStringLeaf original, String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return this.value;
    }

    public final ImmutableStringLeaf withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableStringLeaf(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStringLeaf && this.equalTo(0, (ImmutableStringLeaf)another);
    }

    private boolean equalTo(int synthetic, ImmutableStringLeaf another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StringLeaf").omitNullValues().add("value", (Object)this.value).toString();
    }

    public static ImmutableStringLeaf of(String value) {
        return new ImmutableStringLeaf(value);
    }

    public static ImmutableStringLeaf copyOf(InstantiationGenerics.StringLeaf instance) {
        if (instance instanceof ImmutableStringLeaf) {
            return (ImmutableStringLeaf)instance;
        }
        return ImmutableStringLeaf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstantiationGenerics.StringLeaf", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        @Nullable
        private String value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InstantiationGenerics.StringLeaf instance) {
            Objects.requireNonNull(instance, "instance");
            this.value((String)instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStringLeaf build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStringLeaf(null, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build StringLeaf, some of required attributes are not set " + attributes;
        }
    }
}

