/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.One;
import org.immutables.fixture.builder.OneAndTwo;
import org.immutables.fixture.builder.OneAndTwoAndThree;
import org.immutables.fixture.builder.OneAndTwoAndThreeConcrete;
import org.immutables.fixture.builder.Three;
import org.immutables.fixture.builder.Two;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OneAndTwoAndThreeConcrete", generator="Immutables")
@Immutable
final class ImmutableOneAndTwoAndThreeConcrete
implements OneAndTwoAndThreeConcrete {
    private final String one;
    private final String two;
    private final String three;

    private ImmutableOneAndTwoAndThreeConcrete(String one, String two, String three) {
        this.one = one;
        this.two = two;
        this.three = three;
    }

    @Override
    public String one() {
        return this.one;
    }

    @Override
    public String two() {
        return this.two;
    }

    @Override
    public String three() {
        return this.three;
    }

    public final ImmutableOneAndTwoAndThreeConcrete withOne(String value) {
        String newValue = Objects.requireNonNull(value, "one");
        if (this.one.equals(newValue)) {
            return this;
        }
        return new ImmutableOneAndTwoAndThreeConcrete(newValue, this.two, this.three);
    }

    public final ImmutableOneAndTwoAndThreeConcrete withTwo(String value) {
        String newValue = Objects.requireNonNull(value, "two");
        if (this.two.equals(newValue)) {
            return this;
        }
        return new ImmutableOneAndTwoAndThreeConcrete(this.one, newValue, this.three);
    }

    public final ImmutableOneAndTwoAndThreeConcrete withThree(String value) {
        String newValue = Objects.requireNonNull(value, "three");
        if (this.three.equals(newValue)) {
            return this;
        }
        return new ImmutableOneAndTwoAndThreeConcrete(this.one, this.two, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOneAndTwoAndThreeConcrete && this.equalTo(0, (ImmutableOneAndTwoAndThreeConcrete)another);
    }

    private boolean equalTo(int synthetic, ImmutableOneAndTwoAndThreeConcrete another) {
        return this.one.equals(another.one) && this.two.equals(another.two) && this.three.equals(another.three);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.one.hashCode();
        h += (h << 5) + this.two.hashCode();
        h += (h << 5) + this.three.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OneAndTwoAndThreeConcrete").omitNullValues().add("one", (Object)this.one).add("two", (Object)this.two).add("three", (Object)this.three).toString();
    }

    public static ImmutableOneAndTwoAndThreeConcrete copyOf(OneAndTwoAndThreeConcrete instance) {
        if (instance instanceof ImmutableOneAndTwoAndThreeConcrete) {
            return (ImmutableOneAndTwoAndThreeConcrete)instance;
        }
        return ImmutableOneAndTwoAndThreeConcrete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OneAndTwoAndThreeConcrete", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ONE = 1L;
        private static final long INIT_BIT_TWO = 2L;
        private static final long INIT_BIT_THREE = 4L;
        private long initBits = 7L;
        @Nullable
        private String one;
        @Nullable
        private String two;
        @Nullable
        private String three;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OneAndTwoAndThree instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(OneAndTwo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(One instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(OneAndTwoAndThreeConcrete instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Three instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Two instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof OneAndTwoAndThree) {
                instance = (OneAndTwoAndThree)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.three(instance.three());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof OneAndTwo) {
                instance = (OneAndTwo)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof One) {
                instance = (One)object;
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof OneAndTwoAndThreeConcrete) {
                instance = (OneAndTwoAndThreeConcrete)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.three(instance.three());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.one(instance.one());
                    bits |= 1L;
                }
            }
            if (object instanceof Three) {
                instance = (Three)object;
                if ((bits & 4L) == 0L) {
                    this.three(instance.three());
                    bits |= 4L;
                }
            }
            if (object instanceof Two) {
                instance = (Two)object;
                if ((bits & 2L) == 0L) {
                    this.two(instance.two());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder one(String one) {
            this.one = Objects.requireNonNull(one, "one");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder two(String two) {
            this.two = Objects.requireNonNull(two, "two");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder three(String three) {
            this.three = Objects.requireNonNull(three, "three");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableOneAndTwoAndThreeConcrete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOneAndTwoAndThreeConcrete(this.one, this.two, this.three);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("one");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("two");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("three");
            }
            return "Cannot build OneAndTwoAndThreeConcrete, some of required attributes are not set " + attributes;
        }
    }
}

