/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.custann;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.annotation.ParametersAreNonnullByDefault;
import nonimmutables.CustColl;
import org.immutables.fixture.custann.CustomCollection;
import org.immutables.fixture.custann.ImmutableCustomCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.custann", generator="Gsons")
public final class GsonAdaptersCustomCollection
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (CustomCollectionTypeAdapter.adapts(type)) {
            return new CustomCollectionTypeAdapter(type, gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersCustomCollection(CustomCollection)";
    }

    private static Type[] getTypeArguments(TypeToken<?> type) {
        if (type.getType() instanceof ParameterizedType) {
            return ((ParameterizedType)type.getType()).getActualTypeArguments();
        }
        throw new IllegalStateException("Please supply Type with actual type parameters to serialize " + type.getType() + " instance using method overloads like toJson(instance, type). Runtime raw type alone is not enough. You can use TypeToken class or reflection to construct Type with type arguments");
    }

    @Generated(from="CustomCollection", generator="Gsons")
    private static class CustomCollectionTypeAdapter<E>
    extends TypeAdapter<CustomCollection<E>> {
        public final Integer cintTypeSample = null;
        private final TypeAdapter<E> colTypeAdapter;
        private final TypeAdapter<Integer> cintTypeAdapter;

        CustomCollectionTypeAdapter(TypeToken<?> type, Gson gson) {
            Type[] typeArguments = GsonAdaptersCustomCollection.getTypeArguments(type);
            this.colTypeAdapter = gson.getAdapter(TypeToken.get((Type)typeArguments[0]));
            this.cintTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return CustomCollection.class == type.getRawType() || ImmutableCustomCollection.class == type.getRawType();
        }

        public void write(JsonWriter out, CustomCollection<E> value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCustomCollection(out, value);
            }
        }

        public CustomCollection<E> read(JsonReader in) throws IOException {
            return this.readCustomCollection(in);
        }

        private void writeCustomCollection(JsonWriter out, CustomCollection<E> instance) throws IOException {
            out.beginObject();
            CustColl<E> colElements = instance.col();
            out.name("col");
            out.beginArray();
            for (E e : colElements) {
                this.colTypeAdapter.write(out, e);
            }
            out.endArray();
            CustColl<Integer> cintElements = instance.cint();
            out.name("cint");
            out.beginArray();
            for (Integer e : cintElements) {
                this.cintTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            out.endObject();
        }

        private CustomCollection<E> readCustomCollection(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            CustomCollection.Builder builder = new CustomCollection.Builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, CustomCollection.Builder<E> builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'c': {
                    if ("col".equals(attributeName)) {
                        this.readInCol(in, builder);
                        return;
                    }
                    if (!"cint".equals(attributeName)) break;
                    this.readInCint(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInCol(JsonReader in, CustomCollection.Builder<E> builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Object value = this.colTypeAdapter.read(in);
                    builder.addCol(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.colTypeAdapter.read(in);
                builder.addCol(value);
            }
        }

        private void readInCint(JsonReader in, CustomCollection.Builder<E> builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addCint(in.nextInt());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addCint(in.nextInt());
            }
        }
    }
}

