/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.DeepAndJdkOnly;
import org.immutables.fixture.deep.ImmutableDeep;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeepAndJdkOnly.Container", generator="Immutables")
@Immutable
public final class ImmutableContainer
implements DeepAndJdkOnly.Container {
    private final ImmutableDeep deep;

    private ImmutableContainer(ImmutableDeep deep) {
        this.deep = deep;
    }

    @Override
    public ImmutableDeep getDeep() {
        return this.deep;
    }

    public final ImmutableContainer withDeep(DeepAndJdkOnly.Deep value) {
        if (this.deep == value) {
            return this;
        }
        ImmutableDeep newValue = ImmutableDeep.copyOf(value);
        return new ImmutableContainer(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainer && this.equalTo(0, (ImmutableContainer)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainer another) {
        return this.deep.equals(another.deep);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.deep.hashCode();
        return h;
    }

    public String toString() {
        return "Container{deep=" + this.deep + "}";
    }

    public static ImmutableContainer copyOf(DeepAndJdkOnly.Container instance) {
        if (instance instanceof ImmutableContainer) {
            return (ImmutableContainer)instance;
        }
        return ImmutableContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeepAndJdkOnly.Container", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DEEP = 1L;
        private long initBits = 1L;
        @Nullable
        private DeepAndJdkOnly.Deep deep;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeepAndJdkOnly.Container instance) {
            Objects.requireNonNull(instance, "instance");
            this.deep(instance.getDeep());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deep(int a, int b) {
            return this.deep(ImmutableDeep.of(a, b));
        }

        @CanIgnoreReturnValue
        public final Builder deep(DeepAndJdkOnly.Deep deep) {
            this.deep = ImmutableDeep.copyOf(deep);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableContainer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainer(ImmutableDeep.copyOf(this.deep));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("deep");
            }
            return "Cannot build Container, some of required attributes are not set " + attributes;
        }
    }
}

